/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.springdoc.core.converters.models.Sort;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.utils.SpringDocUtils;

public class SortOpenAPIConverter
implements ModelConverter {
    private static final String SORT_TO_REPLACE = "org.springframework.data.domain.Sort";
    private static final AnnotatedType SORT = new AnnotatedType((Type)((Object)Sort.class)).resolveAsRef(true);
    private final ObjectMapperProvider springDocObjectMapper;

    public SortOpenAPIConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    @Override
    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class<?> cls;
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null && SORT_TO_REPLACE.equals((cls = javaType.getRawClass()).getCanonicalName())) {
            if (!type.isSchemaProperty()) {
                type = SORT;
            } else {
                type.name(SpringDocUtils.getParentTypeName(type, cls));
            }
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }
}

