/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.JavaType;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springdoc.core.providers.ObjectMapperProvider;

public class PolymorphicModelConverter
implements ModelConverter {
    private static final Set<String> PARENT_TYPES_TO_IGNORE = Collections.synchronizedSet(new HashSet());
    private static final Set<String> TYPES_TO_SKIP = Collections.synchronizedSet(new HashSet());
    private final ObjectMapperProvider springDocObjectMapper;

    public PolymorphicModelConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public static void addParentType(String ... parentTypes) {
        PARENT_TYPES_TO_IGNORE.addAll(List.of(parentTypes));
    }

    private io.swagger.v3.oas.models.media.Schema<?> getResolvedSchema(JavaType javaType, io.swagger.v3.oas.models.media.Schema<?> resolvedSchema) {
        if (resolvedSchema instanceof ObjectSchema && resolvedSchema.getProperties() != null) {
            if (resolvedSchema.getProperties().containsKey(javaType.getRawClass().getName())) {
                resolvedSchema = resolvedSchema.getProperties().get(javaType.getRawClass().getName());
            } else if (resolvedSchema.getProperties().containsKey(javaType.getRawClass().getSimpleName())) {
                resolvedSchema = resolvedSchema.getProperties().get(javaType.getRawClass().getSimpleName());
            }
        }
        return resolvedSchema;
    }

    @Override
    public io.swagger.v3.oas.models.media.Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null) {
            for (BeanPropertyBiDefinition propertyDef : this.introspectBeanProperties(javaType)) {
                if (propertyDef.isAnyAnnotated(JsonUnwrapped.class)) {
                    if (!TypeNameResolver.std.getUseFqn()) {
                        PARENT_TYPES_TO_IGNORE.add(javaType.getRawClass().getSimpleName());
                        continue;
                    }
                    PARENT_TYPES_TO_IGNORE.add(javaType.getRawClass().getName());
                    continue;
                }
                Schema declaredSchema = propertyDef.getAnyAnnotation(Schema.class);
                if (declaredSchema == null || !ArrayUtils.isNotEmpty(declaredSchema.oneOf()) && !ArrayUtils.isNotEmpty(declaredSchema.allOf()) || propertyDef.getPrimaryType() == null || propertyDef.getPrimaryType().getRawClass() == null) continue;
                TYPES_TO_SKIP.add(propertyDef.getPrimaryType().getRawClass().getSimpleName());
            }
            if (chain.hasNext()) {
                if (!type.isResolveAsRef() && type.getParent() != null && PARENT_TYPES_TO_IGNORE.stream().noneMatch(ignore -> type.getParent().getName().startsWith((String)ignore))) {
                    type.resolveAsRef(true);
                }
                io.swagger.v3.oas.models.media.Schema<?> resolvedSchema = chain.next().resolve(type, context, chain);
                if ((resolvedSchema = this.getResolvedSchema(javaType, resolvedSchema)) == null || resolvedSchema.get$ref() == null) {
                    return resolvedSchema;
                }
                if (resolvedSchema.get$ref().contains("#/components/schemas/")) {
                    String schemaName = resolvedSchema.get$ref().substring("#/components/schemas/".length());
                    io.swagger.v3.oas.models.media.Schema existingSchema = context.getDefinedModels().get(schemaName);
                    if (existingSchema != null && (existingSchema.getOneOf() != null || existingSchema.getAllOf() != null)) {
                        return resolvedSchema;
                    }
                }
                return this.composePolymorphicSchema(type, resolvedSchema, context.getDefinedModels().values());
            }
        }
        return null;
    }

    private io.swagger.v3.oas.models.media.Schema composePolymorphicSchema(AnnotatedType type, io.swagger.v3.oas.models.media.Schema schema, Collection<io.swagger.v3.oas.models.media.Schema> schemas) {
        String ref = schema.get$ref();
        List<io.swagger.v3.oas.models.media.Schema> composedSchemas = this.findComposedSchemas(ref, schemas);
        if (composedSchemas.isEmpty()) {
            return schema;
        }
        ComposedSchema result = new ComposedSchema();
        if (this.isConcreteClass(type)) {
            result.addOneOfItem(schema);
        }
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        Class<?> clazz = javaType.getRawClass();
        if (TYPES_TO_SKIP.stream().noneMatch(typeToSkip -> typeToSkip.equals(clazz.getSimpleName()))) {
            composedSchemas.forEach(result::addOneOfItem);
        }
        return result;
    }

    private List<io.swagger.v3.oas.models.media.Schema> findComposedSchemas(String ref, Collection<io.swagger.v3.oas.models.media.Schema> schemas) {
        List<io.swagger.v3.oas.models.media.Schema> composedSchemas = schemas.stream().filter(ComposedSchema.class::isInstance).map(ComposedSchema.class::cast).filter(s -> s.getAllOf() != null).filter(s -> s.getAllOf().stream().anyMatch(s2 -> ref.equals(s2.get$ref()))).map(s -> new io.swagger.v3.oas.models.media.Schema().$ref("#/components/schemas/" + s.getName())).toList();
        ArrayList<io.swagger.v3.oas.models.media.Schema> resultSchemas = new ArrayList<io.swagger.v3.oas.models.media.Schema>(composedSchemas);
        for (io.swagger.v3.oas.models.media.Schema childSchema : composedSchemas) {
            String childSchemaRef = childSchema.get$ref();
            resultSchemas.addAll(this.findComposedSchemas(childSchemaRef, schemas));
        }
        return resultSchemas;
    }

    private boolean isConcreteClass(AnnotatedType type) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        Class<?> clazz = javaType.getRawClass();
        return !Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface();
    }

    private List<BeanPropertyBiDefinition> introspectBeanProperties(JavaType javaType) {
        Map forSerializationProps = this.springDocObjectMapper.jsonMapper().getSerializationConfig().introspect(javaType).findProperties().stream().collect(Collectors.toMap(BeanPropertyDefinition::getName, Function.identity()));
        Map forDeserializationProps = this.springDocObjectMapper.jsonMapper().getDeserializationConfig().introspect(javaType).findProperties().stream().collect(Collectors.toMap(BeanPropertyDefinition::getName, Function.identity()));
        return forSerializationProps.keySet().stream().map(key -> new BeanPropertyBiDefinition((BeanPropertyDefinition)forSerializationProps.get(key), (BeanPropertyDefinition)forDeserializationProps.get(key))).toList();
    }

    static {
        PARENT_TYPES_TO_IGNORE.add("JsonSchema");
        PARENT_TYPES_TO_IGNORE.add("Pageable");
        PARENT_TYPES_TO_IGNORE.add("EntityModel");
    }

    private record BeanPropertyBiDefinition(BeanPropertyDefinition forSerialization, BeanPropertyDefinition forDeserialization) {
        public <A extends Annotation> A getAnyAnnotation(Class<A> acls) {
            A anyForSerializationAnnotation = this.getAnyAnnotation(this.forSerialization, acls);
            A anyForDeserializationAnnotation = this.getAnyAnnotation(this.forDeserialization, acls);
            return anyForSerializationAnnotation != null ? anyForSerializationAnnotation : anyForDeserializationAnnotation;
        }

        public <A extends Annotation> boolean isAnyAnnotated(Class<A> acls) {
            return this.getAnyAnnotation(acls) != null;
        }

        public JavaType getPrimaryType() {
            JavaType forSerializationType = null;
            if (this.forSerialization != null) {
                forSerializationType = this.forSerialization.getPrimaryType();
            }
            JavaType forDeserializationType = null;
            if (this.forDeserialization != null) {
                forDeserializationType = this.forDeserialization.getPrimaryType();
            }
            if (forSerializationType != null && forDeserializationType != null && forSerializationType != forDeserializationType) {
                throw new IllegalStateException("The property " + this.forSerialization.getName() + " has different types for serialization and deserialization: " + String.valueOf(forSerializationType) + " and " + String.valueOf(forDeserializationType));
            }
            return forSerializationType != null ? forSerializationType : forDeserializationType;
        }

        private <A extends Annotation> A getAnyAnnotation(BeanPropertyDefinition prop, Class<A> acls) {
            if (prop == null) {
                return null;
            }
            if (prop.getField() != null) {
                return prop.getField().getAnnotation(acls);
            }
            if (prop.getGetter() != null) {
                return prop.getGetter().getAnnotation(acls);
            }
            if (prop.getSetter() != null) {
                return prop.getSetter().getAnnotation(acls);
            }
            return null;
        }
    }
}

