/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.Module;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import io.swagger.v3.core.jackson.SwaggerAnnotationIntrospector;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.StringUtils;

public class SpringDocRequiredModule
extends SimpleModule {
    @Override
    public void setupModule(Module.SetupContext context) {
        context.insertAnnotationIntrospector(new RespectSchemaRequiredAnnotationIntrospector());
    }

    private static class RespectSchemaRequiredAnnotationIntrospector
    extends SwaggerAnnotationIntrospector {
        private RespectSchemaRequiredAnnotationIntrospector() {
        }

        @Override
        public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
            Schema schemaAnnotation = annotatedMember.getAnnotation(Schema.class);
            if (schemaAnnotation != null) {
                Schema.RequiredMode requiredMode = schemaAnnotation.requiredMode();
                if (schemaAnnotation.required() || requiredMode == Schema.RequiredMode.REQUIRED) {
                    return true;
                }
                if (requiredMode == Schema.RequiredMode.NOT_REQUIRED || StringUtils.isNotEmpty(schemaAnnotation.defaultValue())) {
                    return false;
                }
            }
            return super.hasRequiredMarker(annotatedMember);
        }
    }
}

