/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.tomcat.websocket.server.WsContextListener;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsSessionListener;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class WsSci
implements ServletContainerInitializer {
    @Override
    public void onStartup(Set<Class<?>> clazzes, ServletContext ctx) throws ServletException {
        WsServerContainer sc = WsSci.init(ctx, true);
        if (clazzes == null || clazzes.isEmpty()) {
            return;
        }
        HashSet<ServerApplicationConfig> serverApplicationConfigs = new HashSet<ServerApplicationConfig>();
        HashSet<Class<? extends Endpoint>> scannedEndpointClazzes = new HashSet<Class<? extends Endpoint>>();
        HashSet scannedPojoEndpoints = new HashSet();
        try {
            String wsPackage = ContainerProvider.class.getName();
            wsPackage = wsPackage.substring(0, wsPackage.lastIndexOf(46) + 1);
            for (Class<?> clazz : clazzes) {
                int n = clazz.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isInterface(n) || !WsSci.isExported(clazz) || clazz.getName().startsWith(wsPackage)) continue;
                if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                    serverApplicationConfigs.add((ServerApplicationConfig)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                if (Endpoint.class.isAssignableFrom(clazz)) {
                    Class<?> endpoint = clazz;
                    scannedEndpointClazzes.add(endpoint);
                }
                if (!clazz.isAnnotationPresent(ServerEndpoint.class)) continue;
                scannedPojoEndpoints.add(clazz);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new ServletException(e);
        }
        HashSet<ServerEndpointConfig> filteredEndpointConfigs = new HashSet<ServerEndpointConfig>();
        HashSet filteredPojoEndpoints = new HashSet();
        if (serverApplicationConfigs.isEmpty()) {
            filteredPojoEndpoints.addAll(scannedPojoEndpoints);
        } else {
            for (ServerApplicationConfig serverApplicationConfig : serverApplicationConfigs) {
                Set<Class<?>> configFilteredPojos;
                Set<ServerEndpointConfig> configFilteredEndpoints = serverApplicationConfig.getEndpointConfigs(scannedEndpointClazzes);
                if (configFilteredEndpoints != null) {
                    filteredEndpointConfigs.addAll(configFilteredEndpoints);
                }
                if ((configFilteredPojos = serverApplicationConfig.getAnnotatedEndpointClasses(scannedPojoEndpoints)) == null) continue;
                filteredPojoEndpoints.addAll(configFilteredPojos);
            }
        }
        try {
            for (ServerEndpointConfig serverEndpointConfig : filteredEndpointConfigs) {
                sc.addEndpoint(serverEndpointConfig);
            }
            for (Class clazz : filteredPojoEndpoints) {
                sc.addEndpoint(clazz, true);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new ServletException(deploymentException);
        }
    }

    private static boolean isExported(Class<?> type) {
        String packageName = type.getPackage().getName();
        Module module = type.getModule();
        return module.isExported(packageName);
    }

    static WsServerContainer init(ServletContext servletContext, boolean initBySciMechanism) {
        WsServerContainer sc = new WsServerContainer(servletContext);
        servletContext.setAttribute("jakarta.websocket.server.ServerContainer", sc);
        servletContext.addListener(new WsSessionListener(sc));
        if (initBySciMechanism) {
            servletContext.addListener(new WsContextListener());
        }
        return sc;
    }
}

