/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.util.ArrayList;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.CallMethodRule;
import org.xml.sax.SAXException;

final class CallMethodMultiRule
extends CallMethodRule {
    final int multiParamIndex;

    CallMethodMultiRule(String methodName, int paramCount, int multiParamIndex) {
        super(methodName, paramCount);
        this.multiParamIndex = multiParamIndex;
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        Object[] parameters;
        if (this.paramCount > 0) {
            parameters = (Object[])this.digester.popParams();
        } else {
            parameters = new Object[]{};
            super.end(namespace, name);
        }
        ArrayList multiParams = (ArrayList)parameters[this.multiParamIndex];
        Object[] paramValues = new Object[this.paramTypes.length];
        for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
            if (i2 == this.multiParamIndex) continue;
            paramValues[i2] = parameters[i2] == null || parameters[i2] instanceof String && !String.class.isAssignableFrom(this.paramTypes[i2]) ? IntrospectionUtils.convert((String)parameters[i2], this.paramTypes[i2]) : parameters[i2];
        }
        Object target = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (target == null) {
            String sb = "[CallMethodRule]{} Call target is null (targetOffset=" + this.targetOffset + ",stackdepth=" + this.digester.getCount() + ")";
            throw new SAXException(sb);
        }
        if (multiParams == null) {
            paramValues[this.multiParamIndex] = null;
            IntrospectionUtils.callMethodN(target, this.methodName, paramValues, this.paramTypes);
            return;
        }
        for (Object param : multiParams) {
            paramValues[this.multiParamIndex] = param == null || param instanceof String && !String.class.isAssignableFrom(this.paramTypes[this.multiParamIndex]) ? IntrospectionUtils.convert((String)param, this.paramTypes[this.multiParamIndex]) : param;
            IntrospectionUtils.callMethodN(target, this.methodName, paramValues, this.paramTypes);
            StringBuilder code = this.digester.getGeneratedCode();
            if (code == null) continue;
            code.append(this.digester.toVariableName(target)).append('.').append(this.methodName);
            code.append('(');
            for (int i3 = 0; i3 < paramValues.length; ++i3) {
                if (i3 > 0) {
                    code.append(", ");
                }
                if (paramValues[i3] instanceof String) {
                    code.append("\"").append(paramValues[i3].toString()).append("\"");
                    continue;
                }
                code.append(this.digester.toVariableName(paramValues[i3]));
            }
            code.append(");");
            code.append(System.lineSeparator());
        }
    }
}

