/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.hazelcast.shaded.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json31 {
    static Logger LOGGER = LoggerFactory.getLogger(Json31.class);

    public static ObjectMapper mapper() {
        return ObjectMapperHolder.MAPPER;
    }

    public static ObjectMapper converterMapper() {
        return ConverterMapperHolder.MAPPER;
    }

    public static ObjectWriter pretty() {
        return Json31.mapper().writer(new DefaultPrettyPrinter());
    }

    public static String pretty(Object o) {
        try {
            return Json31.pretty().writeValueAsString(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void prettyPrint(Object o) {
        try {
            System.out.println(Json31.pretty().writeValueAsString(o).replace("\r", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> jsonSchemaAsMap(String jsonSchema) {
        try {
            return Json31.mapper().readValue(jsonSchema, Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Exception converting jsonSchema to Map", e);
            return null;
        }
    }

    public static Map<String, Object> jsonSchemaAsMap(Schema schema) {
        try {
            return Json31.mapper().readValue(Json31.mapper().writeValueAsString(schema), Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Exception converting jsonSchema to Map", e);
            return null;
        }
    }

    public static Map<String, Object> jsonSchemaAsMap(JsonNode schema) {
        try {
            return Json31.mapper().readValue(Json31.mapper().writeValueAsString(schema), Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Exception converting jsonSchema to Map", e);
            return null;
        }
    }

    private static final class ConverterMapperHolder {
        private static final ObjectMapper MAPPER = ObjectMapperFactory.createJsonConverter();

        private ConverterMapperHolder() {
        }
    }

    private static final class ObjectMapperHolder {
        private static final ObjectMapper MAPPER = ObjectMapperFactory.createJson31();

        private ObjectMapperHolder() {
        }
    }
}

