/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.jackson.io;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.Module;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import io.jsonwebtoken.io.AbstractSerializer;
import io.jsonwebtoken.jackson.io.JacksonSupplierSerializer;
import io.jsonwebtoken.lang.Assert;
import java.io.OutputStream;

public class JacksonSerializer<T>
extends AbstractSerializer<T> {
    static final String MODULE_ID = "jjwt-jackson";
    static final Module MODULE;
    static final ObjectMapper DEFAULT_OBJECT_MAPPER;
    protected final ObjectMapper objectMapper;

    static ObjectMapper newObjectMapper() {
        return new ObjectMapper().registerModule(MODULE).configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JacksonSerializer() {
        this(DEFAULT_OBJECT_MAPPER);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        this.objectMapper = objectMapper.registerModule(MODULE);
    }

    @Override
    protected void doSerialize(T t, OutputStream out) throws Exception {
        Assert.notNull(out, "OutputStream cannot be null.");
        ObjectWriter writer = this.objectMapper.writer().without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        writer.writeValue(out, t);
    }

    static {
        SimpleModule module = new SimpleModule(MODULE_ID);
        module.addSerializer(JacksonSupplierSerializer.INSTANCE);
        MODULE = module;
        DEFAULT_OBJECT_MAPPER = JacksonSerializer.newObjectMapper();
    }
}

