/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.StringRegistry;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;

public class IdRegistry<T extends Identifiable>
extends StringRegistry<T> {
    public static final Function<Identifiable, String> FN = new Function<Identifiable, String>(){

        @Override
        public String apply(Identifiable identifiable) {
            Assert.notNull(identifiable, "Identifiable argument cannot be null.");
            return Assert.notNull(Strings.clean(identifiable.getId()), "Identifier cannot be null or empty.");
        }
    };

    public static <T extends Identifiable> Function<T, String> fn() {
        return FN;
    }

    public IdRegistry(String name, Collection<T> instances) {
        this(name, instances, true);
    }

    public IdRegistry(String name, Collection<T> instances, boolean caseSensitive) {
        super(name, "id", Assert.notNull(instances, "Collection of Identifiable instances may not be null."), IdRegistry.fn(), caseSensitive);
    }
}

