/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.rest.constant.Paths;
import com.hazelcast.internal.rest.init.RestServiceImpl;
import com.hazelcast.internal.util.phonehome.EnterprisePhoneHomeMetrics;
import com.hazelcast.internal.util.phonehome.Metric;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;

class RestMetricsProvider
implements MetricsProvider {
    RestMetricsProvider() {
    }

    public void provideMetrics(Node node, MetricsCollectionContext context) {
        RestServiceImpl restService = (RestServiceImpl)node.getNodeEngine().getService("hz:impl:restServiceImpl");
        this.collectMetrics(restService).forEach((arg_0, arg_1) -> ((MetricsCollectionContext)context).collect(arg_0, arg_1));
    }

    private Map<Metric, Object> collectMetrics(RestServiceImpl restService) {
        HashMap<Metric, Object> metrics = new HashMap<Metric, Object>();
        metrics.put((Metric)EnterprisePhoneHomeMetrics.RESTS_ENABLED, restService.isEnabled());
        EnumSet.allOf(EnterprisePhoneHomeMetrics.class).stream().filter(m -> m.name().startsWith("RESTS_") && m.name().endsWith("_COUNT")).forEach(m -> metrics.put((Metric)m, 0));
        MetricsEndpoint metricsEndpoint = restService.getMetricsEndpoint();
        if (metricsEndpoint == null) {
            return metrics;
        }
        MetricsEndpoint.MetricDescriptor metricResponse = metricsEndpoint.metric("http.server.requests", null);
        if (metricResponse == null) {
            return metrics;
        }
        Set<Object> endpointSet = Collections.emptySet();
        for (MetricsEndpoint.AvailableTag availableTag : metricResponse.getAvailableTags()) {
            if (!availableTag.getTag().equals("uri")) continue;
            endpointSet = availableTag.getValues();
        }
        for (String method : new String[]{"GET", "POST", "DELETE"}) {
            block2: for (String string : endpointSet) {
                EnterprisePhoneHomeMetrics metric = Paths.pathToPhoneHomeMetrics(string, method);
                if (metric == null || (metricResponse = metricsEndpoint.metric("http.server.requests", List.of("uri:" + string, "method:" + method))) == null) continue;
                for (MetricsEndpoint.Sample measurement : metricResponse.getMeasurements()) {
                    if (!measurement.getStatistic().name().equals("COUNT")) continue;
                    metrics.put((Metric)metric, measurement.getValue().intValue());
                    continue block2;
                }
            }
        }
        return metrics;
    }
}

