/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.service;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.rest.model.AddWanConfigResultModel;
import com.hazelcast.internal.rest.model.WanReplicationConfigModel;
import com.hazelcast.internal.rest.model.WanSyncStatusModel;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.wan.impl.WanSyncStateResult;
import java.util.List;
import java.util.UUID;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class WanService {
    private final NodeEngineImpl nodeEngine;

    @Lazy
    public WanService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public void clearWanQueues(String wanReplicationName, String publisherId) {
        this.nodeEngine.getWanReplicationService().removeWanEvents(wanReplicationName, publisherId);
    }

    public void stopWanPublisher(String wanReplicationName, String publisherId) {
        this.nodeEngine.getWanReplicationService().stop(wanReplicationName, publisherId);
    }

    public void resumeWanPublisher(String wanReplicationName, String publisherId) {
        this.nodeEngine.getWanReplicationService().resume(wanReplicationName, publisherId);
    }

    public void pauseWanPublisher(String wanReplicationName, String publisherId) {
        this.nodeEngine.getWanReplicationService().pause(wanReplicationName, publisherId);
    }

    public UUID syncMap(String wanReplicationName, String publisherId, String mapName) {
        return this.nodeEngine.getWanReplicationService().syncMap(wanReplicationName, publisherId, mapName);
    }

    public UUID syncAllMaps(String wanReplicationName, String publisherId) {
        return this.nodeEngine.getWanReplicationService().syncAllMaps(wanReplicationName, publisherId);
    }

    public AddWanConfigResultModel addWanConfig(WanReplicationConfigModel wanReplicationConfigModel) {
        WanReplicationConfig wanReplicationConfig = wanReplicationConfigModel.toWanReplicationConfig();
        AddWanConfigResult result = this.nodeEngine.getWanReplicationService().addWanReplicationConfig(wanReplicationConfig);
        return new AddWanConfigResultModel(result.getAddedPublisherIds(), result.getIgnoredPublisherIds());
    }

    public UUID mapConsistencyCheck(String wanReplicationName, String publisherId, String mapName) {
        return this.nodeEngine.getWanReplicationService().consistencyCheck(wanReplicationName, publisherId, mapName);
    }

    public WanSyncStatusModel getWanSyncState(UUID uuid) {
        WanSyncStateResult syncResult = this.nodeEngine.getWanReplicationService().getSyncResult(uuid);
        if (syncResult == null) {
            return null;
        }
        JsonObject jsonResult = syncResult.toJson();
        JsonValue jsonValue = jsonResult.get("messages");
        List<String> messages = jsonValue != null ? jsonValue.asArray().values().stream().map(JsonValue::asString).toList() : null;
        return new WanSyncStatusModel(messages, jsonResult.get("stage").asString(), jsonResult.get("progress").asInt(), jsonResult.get("wanReplicationName").asString(), jsonResult.get("wanPublisherId").asString(), jsonResult.get("creationTime").asLong());
    }
}

