/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.service;

import com.hazelcast.access.AccessControlService;
import com.hazelcast.access.AuthenticationContext;
import com.hazelcast.config.rest.RestConfig;
import com.hazelcast.internal.rest.access.SimpleAuthenticationContext;
import com.hazelcast.internal.rest.exception.BadCredentialsException;
import com.hazelcast.internal.rest.model.JwtTokenModel;
import com.hazelcast.internal.rest.model.User;
import com.hazelcast.internal.rest.security.JwtTokenUtil;
import com.hazelcast.internal.rest.security.LockoutService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.time.Duration;
import javax.security.auth.login.LoginException;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class JwtTokenService {
    private final NodeEngineImpl nodeEngine;
    private final AccessControlService accessControlService;
    private final LockoutService lockoutService;
    private final RestConfig restConfig;
    private final JwtTokenUtil tokenUtil;

    public JwtTokenService(@Lazy NodeEngineImpl nodeEngine, @Lazy AccessControlService accessControlService, @Lazy LockoutService lockoutService, @Lazy RestConfig restConfig, JwtTokenUtil tokenUtil) {
        this.nodeEngine = nodeEngine;
        this.accessControlService = accessControlService;
        this.lockoutService = lockoutService;
        this.restConfig = restConfig;
        this.tokenUtil = tokenUtil;
    }

    public JwtTokenModel getJwtToken(User user) {
        try {
            this.lockoutService.ensureNotLockedOut(user.username());
            SimpleAuthenticationContext context = SimpleAuthenticationContext.builder().withClusterName(this.nodeEngine.getConfig().getClusterName()).withUsername(user.username()).withPassword(user.password()).build();
            String[] principalNames = this.accessControlService.authenticate((AuthenticationContext)context);
            this.lockoutService.markSuccessfulLogin(user.username());
            Duration ttl = this.restConfig.getTokenValidityDuration();
            return new JwtTokenModel(this.tokenUtil.generateToken(ttl, principalNames));
        }
        catch (LoginException e) {
            this.lockoutService.markFailedLogin(user.username());
            throw new BadCredentialsException(e.getMessage());
        }
    }
}

