/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.service;

import com.hazelcast.collection.IQueue;
import com.hazelcast.internal.rest.exception.ObjectNotFoundException;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class DataService {
    private final NodeEngineImpl nodeEngine;

    @Lazy
    public DataService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public void clearMap(String mapName) {
        IMap map = this.nodeEngine.getHazelcastInstance().getMap(mapName);
        map.clear();
    }

    public void deleteEntryFromMap(String mapName, String key) {
        IMap map = this.nodeEngine.getHazelcastInstance().getMap(mapName);
        map.delete((Object)key);
    }

    public CompletionStage<Object> getMapValueAsync(String mapName, String key) {
        boolean mapExist = this.nodeEngine.getProxyService().existsDistributedObject("hz:impl:mapService", mapName);
        if (!mapExist) {
            throw new ObjectNotFoundException("Map '" + mapName + "' does not exists in the cluster.");
        }
        IMap map = this.nodeEngine.getHazelcastInstance().getMap(mapName);
        return map.getAsync((Object)key);
    }

    public CompletionStage<Object> putMapValueAsync(String mapName, String key, Object value) {
        IMap map = this.nodeEngine.getHazelcastInstance().getMap(mapName);
        return map.putAsync((Object)key, value);
    }

    public Object pollFromQueue(String queueName, Integer timeoutSeconds) {
        Object item;
        IQueue queue = this.nodeEngine.getHazelcastInstance().getQueue(queueName);
        try {
            if (timeoutSeconds == null) {
                throw new IllegalArgumentException("Timeout is required");
            }
            item = queue.poll((long)timeoutSeconds.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return item;
    }

    public int getQueueSize(String queueName) {
        boolean queueExist = this.nodeEngine.getProxyService().existsDistributedObject("hz:impl:queueService", queueName);
        if (!queueExist) {
            throw new ObjectNotFoundException("Queue '" + queueName + "' does not exists in the cluster.");
        }
        IQueue queue = this.nodeEngine.getHazelcastInstance().getQueue(queueName);
        return queue.size();
    }

    public boolean offerQueueItem(String queueName, Object item, Integer timeoutSeconds) {
        IQueue queue = this.nodeEngine.getHazelcastInstance().getQueue(queueName);
        try {
            if (timeoutSeconds == null) {
                throw new IllegalArgumentException("Timeout is required");
            }
            return queue.offer(item, (long)timeoutSeconds.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

