/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.service;

import com.hazelcast.cp.CPMember;
import com.hazelcast.internal.rest.exception.ObjectNotFoundException;
import com.hazelcast.internal.rest.model.CPGroupIdModel;
import com.hazelcast.internal.rest.model.CPGroupModel;
import com.hazelcast.internal.rest.model.CPMemberModel;
import com.hazelcast.internal.rest.model.CPSessionModel;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.UUID;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class CpService {
    private final NodeEngineImpl nodeEngine;

    @Lazy
    public CpService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public DeferredResult<ResponseEntity<Collection<CPGroupIdModel>>> getGroups() {
        DeferredResult<ResponseEntity<Collection<CPGroupIdModel>>> deferredResult = new DeferredResult<ResponseEntity<Collection<CPGroupIdModel>>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService().getCPGroupIds().whenComplete((cpGroupIds, throwable) -> {
            if (throwable != null) {
                deferredResult.setErrorResult(throwable);
            } else if (cpGroupIds == null || cpGroupIds.isEmpty()) {
                deferredResult.setErrorResult(new ObjectNotFoundException("No CP groups found"));
            } else {
                deferredResult.setResult(ResponseEntity.ok(cpGroupIds.stream().map(CPGroupIdModel::fromCPGroupId).toList()));
            }
        });
        return deferredResult;
    }

    public DeferredResult<ResponseEntity<CPGroupModel>> getGroupByName(String groupName) {
        DeferredResult<ResponseEntity<CPGroupModel>> deferredResult = new DeferredResult<ResponseEntity<CPGroupModel>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService().getCPGroup(groupName).whenComplete((cpGroup, throwable) -> {
            if (throwable != null) {
                deferredResult.setErrorResult(throwable);
            } else if (cpGroup == null) {
                deferredResult.setErrorResult(new ObjectNotFoundException("CP group could not be found with the name: " + groupName));
            } else {
                deferredResult.setResult(ResponseEntity.ok(CPGroupModel.fromCPGroup(cpGroup)));
            }
        });
        return deferredResult;
    }

    public CPMemberModel getLocalCPMember() {
        CPMember localCPMember = this.nodeEngine.getHazelcastInstance().getCPSubsystem().getLocalCPMember();
        if (localCPMember == null) {
            throw new ObjectNotFoundException("Local member is not part of CP Subsystem.");
        }
        return CPMemberModel.fromCPMember(localCPMember);
    }

    public DeferredResult<ResponseEntity<Void>> destroyGroup(String groupName) {
        if ("METADATA".equals(groupName)) {
            throw new IllegalArgumentException("Meta data CP group [METADATA] cannot be destroyed");
        }
        DeferredResult<ResponseEntity<Void>> deferredResult = new DeferredResult<ResponseEntity<Void>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService().forceDestroyCPGroup(groupName).whenComplete((v, throwable) -> {
            if (throwable != null) {
                deferredResult.setErrorResult(throwable);
            } else {
                deferredResult.setResult(ResponseEntity.ok().build());
            }
        });
        return deferredResult;
    }

    public DeferredResult<ResponseEntity<Collection<CPMemberModel>>> getCPMembers() {
        DeferredResult<ResponseEntity<Collection<CPMemberModel>>> deferredResult = new DeferredResult<ResponseEntity<Collection<CPMemberModel>>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService().getCPMembers().whenComplete((cpMembers, throwable) -> {
            if (throwable != null) {
                deferredResult.setErrorResult(throwable);
            } else {
                deferredResult.setResult(ResponseEntity.ok(cpMembers.stream().map(CPMemberModel::fromCPMember).toList()));
            }
        });
        return deferredResult;
    }

    public DeferredResult<ResponseEntity<Void>> resetCPSubsystem() {
        DeferredResult<ResponseEntity<Void>> deferredResult = new DeferredResult<ResponseEntity<Void>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService().reset().whenComplete((v, throwable) -> {
            if (throwable == null) {
                deferredResult.setResult(ResponseEntity.ok().build());
            } else {
                deferredResult.setErrorResult(throwable);
            }
        });
        return deferredResult;
    }

    public DeferredResult<ResponseEntity<Void>> removeCPMember(UUID uuid) {
        DeferredResult<ResponseEntity<Void>> deferredResult = new DeferredResult<ResponseEntity<Void>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService().removeCPMember(uuid).whenComplete((v, throwable) -> {
            if (throwable == null) {
                deferredResult.setResult(ResponseEntity.ok().build());
            } else {
                deferredResult.setErrorResult(throwable);
            }
        });
        return deferredResult;
    }

    public DeferredResult<ResponseEntity<Collection<CPSessionModel>>> getCPSessions(String groupName) {
        DeferredResult<ResponseEntity<Collection<CPSessionModel>>> deferredResult = new DeferredResult<ResponseEntity<Collection<CPSessionModel>>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSessionManagementService().getAllSessions(groupName).whenComplete((cpSessions, throwable) -> {
            if (throwable == null) {
                deferredResult.setResult(ResponseEntity.ok(CPSessionModel.fromCPSessions(cpSessions)));
            } else {
                deferredResult.setErrorResult(throwable);
            }
        });
        return deferredResult;
    }

    public DeferredResult<ResponseEntity<Void>> forceCloseCPSession(String groupName, long sessionId) {
        DeferredResult<ResponseEntity<Void>> deferredResult = new DeferredResult<ResponseEntity<Void>>();
        this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSessionManagementService().forceCloseSession(groupName, sessionId).whenComplete((sessionClosed, throwable) -> {
            if (throwable == null) {
                if (sessionClosed.booleanValue()) {
                    deferredResult.setResult(ResponseEntity.ok().build());
                } else {
                    deferredResult.setErrorResult(new ObjectNotFoundException("No session matches with the provided group name or session ID."));
                }
            } else {
                deferredResult.setErrorResult(throwable);
            }
        });
        return deferredResult;
    }
}

