/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.service;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.config.service.impl.EnterpriseConfigFileService;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.monitor.LicenseInfo;
import com.hazelcast.internal.monitor.impl.rest.LicenseInfoImpl;
import com.hazelcast.internal.rest.model.ClusterStateModel;
import com.hazelcast.internal.rest.model.ClusterStatusModel;
import com.hazelcast.internal.rest.model.ClusterVersionModel;
import com.hazelcast.internal.rest.model.ConfigActionResultModel;
import com.hazelcast.internal.rest.model.LicenseInfoModel;
import com.hazelcast.internal.rest.model.LogLevelModel;
import com.hazelcast.internal.rest.model.MemberConfigResponseModel;
import com.hazelcast.internal.rest.model.MemberDetailModel;
import com.hazelcast.internal.rest.model.SetLicenseInfoResultModel;
import com.hazelcast.internal.rest.util.MemberUtil;
import com.hazelcast.internal.server.Server;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.impl.LoggingServiceImpl;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class ClusterService {
    public static final ClusterState[] VALID_STATES = new ClusterState[]{ClusterState.ACTIVE, ClusterState.NO_MIGRATION, ClusterState.FROZEN, ClusterState.PASSIVE};
    private static final ILogger LOGGER = Logger.getLogger(ClusterService.class);
    private static final HazelcastProperty ALLOW_CONFIG_TEMPLATING = new HazelcastProperty("hazelcast.rest.allow.config.templating", false);
    private final NodeEngineImpl nodeEngine;
    private final EnterpriseConfigFileService configFileService;

    @Lazy
    public ClusterService(NodeEngineImpl nodeEngine, EnterpriseConfigFileService configFileService) {
        this.nodeEngine = nodeEngine;
        this.configFileService = configFileService;
    }

    public ClusterStatusModel getClusterStatus() {
        List<MemberDetailModel> members = MemberUtil.getMembers(this.nodeEngine);
        Server server = this.nodeEngine.getNode().getServer();
        ServerConnectionManager cm = server.getConnectionManager(EndpointQualifier.CLIENT);
        int clientCount = cm == null ? 0 : cm.connectionCount(ServerConnection::isClient);
        return new ClusterStatusModel(members, clientCount, server.connectionCount(), this.nodeEngine.getClusterService().getClusterState().name(), this.nodeEngine.getClusterService().getClusterVersion().toString());
    }

    public ClusterStateModel getClusterState() {
        return new ClusterStateModel(this.nodeEngine.getClusterService().getClusterState());
    }

    public ClusterVersionModel getClusterVersion() {
        Version version = this.nodeEngine.getClusterService().getClusterVersion();
        return new ClusterVersionModel(version.getMajor(), version.getMinor());
    }

    public void changeClusterState(ClusterState state) {
        this.nodeEngine.getClusterService().changeClusterState(state);
    }

    public void changeClusterVersion(Version version) {
        this.nodeEngine.getClusterService().changeClusterVersion(version);
    }

    public boolean triggerForceStart() {
        return this.nodeEngine.getNode().getNodeExtension().getInternalHotRestartService().triggerForceStart();
    }

    public boolean triggerPartialStart() {
        return this.nodeEngine.getNode().getNodeExtension().getInternalHotRestartService().triggerPartialStart();
    }

    public void backup() {
        this.nodeEngine.getNode().getClusterService().getPersistenceService().backup();
    }

    public void backupInterrupt() {
        this.nodeEngine.getNode().getClusterService().getPersistenceService().interruptBackupTask();
    }

    public LicenseInfoModel getLicenseInfo() {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.nodeEngine.getNode().getNodeExtension();
        License license = nodeExtension.getLicense();
        assert (license != null);
        return LicenseInfoModel.fromLicenseInfo((LicenseInfo)new LicenseInfoImpl(license));
    }

    public DeferredResult<SetLicenseInfoResultModel> setLicenseInfo(String licenseKey) {
        DeferredResult<SetLicenseInfoResultModel> result = new DeferredResult<SetLicenseInfoResultModel>();
        ConfigurationService configurationService = (ConfigurationService)this.nodeEngine.getService("hz:configurationService");
        CompletableFuture updateFuture = configurationService.updateLicenseAsync(licenseKey);
        updateFuture.whenComplete((Void2, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof InvalidLicenseException) {
                    result.setErrorResult(new IllegalArgumentException(throwable.getMessage()));
                } else {
                    result.setErrorResult(throwable);
                }
            } else {
                boolean persistenceEnabled = this.nodeEngine.getConfig().getDynamicConfigurationConfig().isPersistenceEnabled();
                String message = EnterpriseNodeExtension.licenseChangeMessage((boolean)persistenceEnabled);
                result.setResult(new SetLicenseInfoResultModel(persistenceEnabled, message));
            }
        });
        return result;
    }

    public LogLevelModel getLogLevel() {
        LoggingServiceImpl loggingService = (LoggingServiceImpl)this.nodeEngine.getLoggingService();
        Level level = loggingService.getLevel();
        return new LogLevelModel(level == null ? null : level.getName());
    }

    public void setLogLevel(String level) {
        LoggingServiceImpl loggingService = (LoggingServiceImpl)this.nodeEngine.getLoggingService();
        loggingService.setLevel(level);
    }

    public void resetLogLevel() {
        LoggingServiceImpl loggingService = (LoggingServiceImpl)this.nodeEngine.getLoggingService();
        loggingService.resetLevel();
    }

    public DeferredResult<ResponseEntity<Collection<MemberConfigResponseModel>>> getMemberConfigs() {
        DeferredResult<ResponseEntity<Collection<MemberConfigResponseModel>>> deferredResult = new DeferredResult<ResponseEntity<Collection<MemberConfigResponseModel>>>();
        try {
            Map configs = (Map)this.configFileService.getConfigurationForAllMembers().get();
            deferredResult.setResult(((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body(MemberConfigResponseModel.fromMap(configs)));
        }
        catch (InterruptedException | ExecutionException e) {
            deferredResult.setErrorResult(e);
        }
        return deferredResult;
    }

    public DeferredResult<ResponseEntity<MemberConfigResponseModel>> getMemberConfigByUuid(UUID memberId) {
        DeferredResult<ResponseEntity<MemberConfigResponseModel>> deferredResult = new DeferredResult<ResponseEntity<MemberConfigResponseModel>>();
        try {
            String config = Objects.requireNonNullElse((String)this.configFileService.getConfiguration(memberId).get(), "");
            deferredResult.setResult(((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body(new MemberConfigResponseModel(memberId, config)));
        }
        catch (InterruptedException | ExecutionException e) {
            deferredResult.setErrorResult(e);
        }
        return deferredResult;
    }

    public ConfigActionResultModel reload() {
        ConfigurationService configurationService = (ConfigurationService)this.nodeEngine.getService("hz:configurationService");
        ConfigUpdateResult configUpdateResult = configurationService.update();
        return ConfigActionResultModel.fromConfigUpdateResult(configUpdateResult);
    }

    public ConfigActionResultModel updateConfig(String newConfigAsString) {
        Config from;
        Properties propertiesToUse = ClusterService.getPropertiesToUse();
        try {
            from = Config.loadFromString((String)newConfigAsString, (Properties)propertiesToUse);
        }
        catch (Exception e) {
            LOGGER.warning("Configuration validation failed with " + e.getMessage(), (Throwable)e);
            throw new InvalidConfigurationException("Configuration validation failed. Please check server logs for more details.");
        }
        ConfigurationService configurationService = (ConfigurationService)this.nodeEngine.getService("hz:configurationService");
        ConfigUpdateResult configUpdateResult = configurationService.update(from);
        return ConfigActionResultModel.fromConfigUpdateResult(configUpdateResult);
    }

    private static Properties getPropertiesToUse() {
        boolean templatingAllowed = "true".equalsIgnoreCase(ALLOW_CONFIG_TEMPLATING.getSystemProperty());
        return templatingAllowed ? System.getProperties() : new Properties();
    }

    public boolean isValid(ClusterState state) {
        for (ClusterState validState : VALID_STATES) {
            if (validState != state) continue;
            return true;
        }
        return false;
    }
}

