/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.security;

import com.hazelcast.config.rest.RestConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.springframework.web.filter.OncePerRequestFilter;

public class SslFilter
extends OncePerRequestFilter {
    public static final int ONE_YEAR_IN_SECONDS = 31536000;
    private static final ILogger LOGGER = Logger.getLogger(SslFilter.class);
    private final RestConfig restConfig;

    public SslFilter(RestConfig restConfig) {
        this.restConfig = restConfig;
    }

    @Override
    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws IOException {
        if (this.restConfig.getSsl().isEnabled()) {
            response.setHeader("Strict-Transport-Security", "max-age=31536000");
        }
        try {
            filterChain.doFilter(request, response);
        }
        catch (ServletException e) {
            LOGGER.warning("Unable to process the request with error " + e.getMessage(), (Throwable)e);
            response.setStatus(400);
            response.sendError(400, "Unable to process the request. Please check server logs for more details.");
        }
    }
}

