/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.security;

import com.hazelcast.access.AccessControlService;
import com.hazelcast.config.rest.RestConfig;
import com.hazelcast.internal.rest.security.JwtAuthFilter;
import com.hazelcast.internal.rest.security.JwtTokenUtil;
import com.hazelcast.internal.rest.security.SslFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SecurityFilterConfig {
    private final AccessControlService accessControlService;
    private final JwtTokenUtil tokenUtil;
    private final RestConfig restConfig;

    public SecurityFilterConfig(@Lazy AccessControlService accessControlService, JwtTokenUtil tokenUtil, @Lazy RestConfig restConfig) {
        this.accessControlService = accessControlService;
        this.tokenUtil = tokenUtil;
        this.restConfig = restConfig;
    }

    @Bean
    public FilterRegistrationBean<JwtAuthFilter> loggingFilter() {
        FilterRegistrationBean<JwtAuthFilter> registrationBean = new FilterRegistrationBean<JwtAuthFilter>();
        registrationBean.setFilter(new JwtAuthFilter(this.accessControlService, this.tokenUtil));
        registrationBean.addUrlPatterns("/hazelcast/rest/api/v1/*");
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<SslFilter> sslConfigFilter() {
        FilterRegistrationBean<SslFilter> registrationBean = new FilterRegistrationBean<SslFilter>();
        registrationBean.setFilter(new SslFilter(this.restConfig));
        registrationBean.addUrlPatterns("/*");
        return registrationBean;
    }
}

