/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.security;

import com.hazelcast.access.AccessControlService;
import com.hazelcast.access.AuthorizationContext;
import com.hazelcast.internal.rest.access.SimpleAuthorizationContext;
import com.hazelcast.internal.rest.security.JwtTokenUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtAuthFilter
extends OncePerRequestFilter {
    private final String header = "Authorization";
    private final String prefix = "Bearer ";
    private final AccessControlService accessControlService;
    private final JwtTokenUtil tokenUtil;
    private final List<String> excludeUrlPatterns = List.of("/hazelcast/rest/api/v1/token");

    public JwtAuthFilter(AccessControlService accessControlService, JwtTokenUtil tokenUtil) {
        this.accessControlService = accessControlService;
        this.tokenUtil = tokenUtil;
    }

    @Override
    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws IOException {
        block6: {
            String authenticationHeader = request.getHeader("Authorization");
            if (this.tokenExists(authenticationHeader)) {
                try {
                    Claims claims = this.validateToken(authenticationHeader);
                    String[] roles = JwtTokenUtil.parseRolesClaim(claims);
                    boolean isAccessGranted = this.accessControlService.isAccessGranted((AuthorizationContext)SimpleAuthorizationContext.builder().withMethodName(request.getMethod()).build(), roles);
                    if (isAccessGranted) {
                        chain.doFilter(request, response);
                        break block6;
                    }
                    response.setStatus(403);
                    response.sendError(403);
                }
                catch (MalformedJwtException | UnsupportedJwtException | ServletException e) {
                    response.setStatus(400);
                    response.sendError(400, e.getMessage());
                }
                catch (ExpiredJwtException | SignatureException e) {
                    response.setStatus(401);
                    response.sendError(401, e.getMessage());
                }
            } else {
                response.setStatus(401);
                response.sendError(401);
            }
        }
    }

    @Override
    protected boolean shouldNotFilter(@Nonnull HttpServletRequest request) {
        return this.excludeUrlPatterns.stream().anyMatch(exclude -> exclude.equalsIgnoreCase(request.getServletPath()));
    }

    private boolean tokenExists(String authenticationHeader) {
        return authenticationHeader != null && authenticationHeader.startsWith("Bearer ");
    }

    private Claims validateToken(String authenticationHeader) {
        String jwtToken = authenticationHeader.replace("Bearer ", "");
        return this.tokenUtil.parseToken(jwtToken);
    }
}

