/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.internal.util.MapUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Map;

@Schema(description="DTO of WanConsumerConfig.")
public class WanConsumerConfigModel {
    private String className;
    private Map<String, String> properties;
    private boolean persistWanReplicatedData;

    public WanConsumerConfigModel() {
        this.properties = Collections.emptyMap();
    }

    public WanConsumerConfigModel(String className, Map<String, String> properties, boolean persistWanReplicatedData) {
        this.className = className;
        this.properties = properties;
        this.persistWanReplicatedData = persistWanReplicatedData;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isPersistWanReplicatedData() {
        return this.persistWanReplicatedData;
    }

    public void setPersistWanReplicatedData(boolean persistWanReplicatedData) {
        this.persistWanReplicatedData = persistWanReplicatedData;
    }

    public WanConsumerConfig toWanConsumerConfig() {
        WanConsumerConfig wanConsumerConfig = new WanConsumerConfig();
        wanConsumerConfig.setClassName(this.className);
        Map mappedProps = MapUtil.createHashMap((int)this.properties.size());
        this.properties.forEach((k, v) -> mappedProps.put(k, v));
        wanConsumerConfig.setProperties(mappedProps);
        wanConsumerConfig.setPersistWanReplicatedData(this.persistWanReplicatedData);
        return wanConsumerConfig;
    }
}

