/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Member health")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MemberHealthModel {
    @Schema(description="Node state")
    private String nodeState;
    @Schema(description="Cluster state")
    private String clusterState;
    @Schema(description="Is the partition table on the member safe")
    private Boolean isMemberSafe;
    @Schema(description="Number of members in the cluster")
    private Integer numberOfMembers;

    public MemberHealthModel() {
    }

    public MemberHealthModel(String nodeState, String clusterState, Boolean isMemberSafe, Integer numberOfMembers) {
        this.nodeState = nodeState;
        this.clusterState = clusterState;
        this.isMemberSafe = isMemberSafe;
        this.numberOfMembers = numberOfMembers;
    }

    public String getNodeState() {
        return this.nodeState;
    }

    public void setNodeState(String nodeState) {
        this.nodeState = nodeState;
    }

    public String getClusterState() {
        return this.clusterState;
    }

    public void setClusterState(String clusterState) {
        this.clusterState = clusterState;
    }

    public Boolean getMemberSafe() {
        return this.isMemberSafe;
    }

    public void setMemberSafe(Boolean memberSafe) {
        this.isMemberSafe = memberSafe;
    }

    public Integer getNumberOfMembers() {
        return this.numberOfMembers;
    }

    public void setNumberOfMembers(Integer numberOfMembers) {
        this.numberOfMembers = numberOfMembers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberHealthModel that = (MemberHealthModel)o;
        return Objects.equals(this.nodeState, that.nodeState) && Objects.equals(this.clusterState, that.clusterState) && Objects.equals(this.isMemberSafe, that.isMemberSafe) && Objects.equals(this.numberOfMembers, that.numberOfMembers);
    }

    public int hashCode() {
        return Objects.hash(this.nodeState, this.clusterState, this.isMemberSafe, this.numberOfMembers);
    }

    public String toString() {
        return "MemberHealthModel{nodeState='" + this.nodeState + "', clusterState='" + this.clusterState + "', isMemberSafe=" + this.isMemberSafe + "', clusterSize=" + this.numberOfMembers + "}";
    }
}

