/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.hazelcast.internal.monitor.LicenseInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public record LicenseInfoModel(@Schema(description="The expiration time in milliseconds since epoch, of the license key assigned on the node.") long expirationTimeMs, @Schema(description="The maximum number of nodes in the cluster, allowed for the license key assigned on the node.") int maxNodeCount, @Schema(description="The maximum size of tiered store in the cluster, allowed for the license key assigned on the node.") int allowedTieredStoreSize, @Schema(description="The maximum size of native memory in the cluster, allowed for the license key assigned on the node.") int allowedNativeMemorySize, @Schema(description="The maximum number of TPC cores, allowed for the license key assigned on the node.") int allowedTpcCores, @Schema(description="Hash of the license key assigned on the node, computed as SHA-256 hash of the key encoded as a Base64 string.") String keyHash, @Schema(description="Licensed features of the license key assigned on the node.") Collection<String> features) {
    public static LicenseInfoModel fromLicenseInfo(LicenseInfo licenseInfo) {
        return new LicenseInfoModel(licenseInfo.getExpirationTime(), licenseInfo.getMaxNodeCountAllowed(), licenseInfo.getAllowedTieredStoreSize(), licenseInfo.getAllowedNativeMemorySize(), licenseInfo.getAllowedTpcCores(), licenseInfo.getKeyHash(), licenseInfo.getFeatures());
    }
}

