/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.model;

import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.internal.rest.model.DiscoveryStrategyConfigModel;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;

@Schema(name="DiscoveryConfig", description="DTP representation of DiscoveryStrategyConfig.")
public class DiscoveryConfigModel {
    private String nodeFilterClass;
    private List<DiscoveryStrategyConfigModel> discoveryStrategies;

    public DiscoveryConfigModel() {
        this.discoveryStrategies = Collections.emptyList();
    }

    public DiscoveryConfigModel(String nodeFilterClass, List<DiscoveryStrategyConfigModel> discoveryStrategies) {
        this.nodeFilterClass = nodeFilterClass;
        this.discoveryStrategies = discoveryStrategies;
    }

    public String getNodeFilterClass() {
        return this.nodeFilterClass;
    }

    public void setNodeFilterClass(String nodeFilterClass) {
        this.nodeFilterClass = nodeFilterClass;
    }

    public List<DiscoveryStrategyConfigModel> getDiscoveryStrategies() {
        return this.discoveryStrategies;
    }

    public void setDiscoveryStrategies(List<DiscoveryStrategyConfigModel> discoveryStrategies) {
        this.discoveryStrategies = discoveryStrategies;
    }

    public DiscoveryConfig toDiscoveryConfig() {
        DiscoveryConfig discoveryConfig = new DiscoveryConfig();
        discoveryConfig.setNodeFilterClass(this.nodeFilterClass);
        if (this.discoveryStrategies != null) {
            this.discoveryStrategies.forEach(strategy -> discoveryConfig.addDiscoveryStrategyConfig(strategy.toDiscoveryStrategyConfig()));
        }
        return discoveryConfig;
    }
}

