/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.exception;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.dynamicconfig.EnterpriseClusterWideConfigurationService;
import com.hazelcast.internal.rest.exception.BadCredentialsException;
import com.hazelcast.internal.rest.exception.CustomInterruptedException;
import com.hazelcast.internal.rest.exception.ObjectNotFoundException;
import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class CustomExceptionHandler {
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<StatusCodeAndMessage> handleTypeMismatch(MethodArgumentTypeMismatchException ex) {
        String name = ex.getName();
        String type = Objects.requireNonNull(ex.getRequiredType()).getSimpleName();
        Object value = ex.getValue();
        String message = String.format("'%s' should be a valid '%s', '%s' is not accepted.", name, type, value);
        return ResponseEntity.badRequest().body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), message));
    }

    @ExceptionHandler(value={ObjectNotFoundException.class})
    public ResponseEntity<StatusCodeAndMessage> handleObjectNotFoundException(ObjectNotFoundException ex) {
        return ResponseEntity.status(HttpStatus.NOT_FOUND).body(new StatusCodeAndMessage(HttpStatus.NOT_FOUND.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={InvalidConfigurationException.class})
    public ResponseEntity<StatusCodeAndMessage> handleInvalidConfigurationException(InvalidConfigurationException ex) {
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={EnterpriseClusterWideConfigurationService.ConfigurationValidationException.class})
    public ResponseEntity<StatusCodeAndMessage> handleConfigurationValidationException(EnterpriseClusterWideConfigurationService.ConfigurationValidationException ex) {
        Throwable cause = ex.getCause();
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(new StatusCodeAndMessage(HttpStatus.INTERNAL_SERVER_ERROR.value(), ((Throwable)Objects.requireNonNullElse(cause, ex)).getMessage()));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<StatusCodeAndMessage> handleOtherException(Exception ex) {
        Object message = ex.getMessage();
        if (message == null) {
            message = "Exception: " + ex.getClass().getName();
        }
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(new StatusCodeAndMessage(HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)message));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<StatusCodeAndMessage> handleInvalidFormatException(HttpMessageNotReadableException ex) {
        InvalidFormatException e;
        Throwable throwable = ex.getCause();
        Object message = throwable instanceof InvalidFormatException ? ((e = (InvalidFormatException)throwable).getTargetType().isEnum() ? String.valueOf(e.getValue()) + " is not a valid " + e.getTargetType().getSimpleName() + ". Please provide one of the valid values: " + Arrays.toString(e.getTargetType().getEnumConstants()) : "Please provide a valid value for field " + e.getTargetType().getSimpleName() + ". You provided value as " + String.valueOf(e.getValue()) + ".") : "Please provide a valid value.";
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), (String)message));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<StatusCodeAndMessage> handleMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        String field = Objects.requireNonNullElseGet(ex.getFieldError(), () -> new FieldError("", "", "")).getField();
        String message = Objects.requireNonNullElseGet(ex.getFieldError(), () -> new FieldError("", "", "")).getDefaultMessage();
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), field + " " + message));
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<StatusCodeAndMessage> handleIllegalArgumentException(IllegalArgumentException ex) {
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    public ResponseEntity<StatusCodeAndMessage> handleHttpMessageConversionException(HttpMessageConversionException ex) {
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={CustomInterruptedException.class})
    public ResponseEntity<StatusCodeAndMessage> handleCustomInterruptedException(CustomInterruptedException ex) {
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(new StatusCodeAndMessage(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    public ResponseEntity<StatusCodeAndMessage> handleLoginException(BadCredentialsException ex) {
        return ResponseEntity.status(HttpStatus.UNAUTHORIZED).body(new StatusCodeAndMessage(HttpStatus.UNAUTHORIZED.value(), ex.getMessage()));
    }

    @ExceptionHandler(value={EnterpriseClusterWideConfigurationService.ConfigurationParsingException.class})
    public ResponseEntity<StatusCodeAndMessage> handleConfigurationParsingException(EnterpriseClusterWideConfigurationService.ConfigurationParsingException ex) {
        return this.handleOtherException((Exception)Objects.requireNonNullElse(ex.getCause(), ex));
    }

    @ExceptionHandler(value={CompletionException.class})
    public ResponseEntity<StatusCodeAndMessage> handleCompletionException(CompletionException ex) {
        Throwable cause = ex.getCause();
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(new StatusCodeAndMessage(HttpStatus.BAD_REQUEST.value(), ((Throwable)Objects.requireNonNullElse(cause, ex)).getMessage()));
    }

    @ExceptionHandler(value={TargetNotMemberException.class})
    public ResponseEntity<StatusCodeAndMessage> handleTargetNotMemberException(TargetNotMemberException ex) {
        return ResponseEntity.status(HttpStatus.NOT_FOUND).body(new StatusCodeAndMessage(HttpStatus.NOT_FOUND.value(), ex.getMessage()));
    }
}

