/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.internal.rest.service.ClusterService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hazelcast/rest/api/v1/cluster/persistence"})
public class PersistenceController {
    ClusterService clusterService;

    public PersistenceController(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @PostMapping(value={"/trigger-force-start"})
    @Operation(summary="Triggers node to force start by skipping hot-restart.", tags={"Persistence Controller"}, description="Forces node to start by skipping hot-restart completely and removing all hot-restart data\neven if node is still on validation phase or loading hot-restart data.", responses={@ApiResponse(responseCode="200", description="Force start triggered successfully.", content={@Content}), @ApiResponse(responseCode="503", description="Forced start failed.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(value="{\n  \"statusCode\": 503,\n  \"message\": \"Forced start failed.\"\n}")})})})
    ResponseEntity<StatusCodeAndMessage> triggerForceStart() {
        if (this.clusterService.triggerForceStart()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status(HttpStatus.SERVICE_UNAVAILABLE).body(new StatusCodeAndMessage(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Forced start failed."));
    }

    @PostMapping(value={"/trigger-partial-start"})
    @Operation(summary="Triggers partial start if the cluster cannot be started with full recovery.", tags={"Persistence Controller"}, description="Triggers partial start if the cluster cannot be started with full recovery and\nHotRestartPersistenceConfig#clusterDataRecoveryPolicy is set accordingly.", responses={@ApiResponse(responseCode="200", description="Partial start triggered successfully.", content={@Content}), @ApiResponse(responseCode="503", description="Partial start failed.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(value="{\n  \"statusCode\": 503,\n  \"message\": \"Partial start failed.\"\n}")})})})
    ResponseEntity<StatusCodeAndMessage> triggerPartialStart() {
        if (this.clusterService.triggerPartialStart()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status(HttpStatus.SERVICE_UNAVAILABLE).body(new StatusCodeAndMessage(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Partial start failed."));
    }

    @PostMapping(value={"/trigger-backup"})
    @Operation(summary="Triggers an attempt to perform a cluster-wide data backup.", tags={"Persistence Controller"}, description="Attempts to perform a cluster-wide data backup. Each node will create a directory under the defined backup dir with the name `backup-` followed by the cluster time defined by this node. The backup request is performed transactional operation. This method will throw an exception if another request (transaction) is already in progress. If a node is already performing a backup (there is a file indicating a backup is in progress),\nthe node will only log a warning and ignore the backup request.", responses={@ApiResponse(responseCode="200", description="Backup attempt triggered successfully.")})
    ResponseEntity<Void> triggerBackup() {
        this.clusterService.backup();
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/trigger-backup-interrupt"})
    @Operation(summary="Triggers an attempt to interrupt the backup tasks on each cluster member if one is currently running.", tags={"Persistence Controller"}, description="Interrupts the backup tasks on each cluster member if one is currently running. The contents of the target backup directories will be left as-is.", responses={@ApiResponse(responseCode="200", description="Backup interrupt attempt triggered successfully.")})
    ResponseEntity<Void> backupInterrupt() {
        this.clusterService.backupInterrupt();
        return ResponseEntity.ok().build();
    }
}

