/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.internal.rest.model.JwtTokenModel;
import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.internal.rest.model.User;
import com.hazelcast.internal.rest.service.JwtTokenService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hazelcast/rest/api/v1"})
public class JwtTokenController {
    private final JwtTokenService tokenService;

    public JwtTokenController(JwtTokenService tokenService) {
        this.tokenService = tokenService;
    }

    @PostMapping(value={"/token"})
    @Operation(summary="Get JWT token", tags={"JWT Token Controller"}, description="Endpoint for user authentication to obtain a JWT token.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=JwtTokenModel.class), examples={@ExampleObject(name="OK", description="JWT token has been retrieved successfully.", value="{\n  \"token\": \"<token>\"\n}")})}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="OK", description="Username/password provided don't match the expected values.", value="{\n  \"statusCode\": 401,\n  \"message\": \"Username/password provided don't match the expected values.\"\n}")})})})
    ResponseEntity<JwtTokenModel> getToken(@Parameter(in=ParameterIn.DEFAULT, description="User credentials", required=true, schema=@Schema) @RequestBody User user) {
        if (user == null || StringUtils.isBlank(user.username()) || StringUtils.isBlank(user.password())) {
            throw new IllegalArgumentException("username and password must not be blank");
        }
        return ResponseEntity.ok().body(this.tokenService.getJwtToken(user));
    }
}

