/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.controller;

import com.hazelcast.internal.rest.model.CPGroupIdModel;
import com.hazelcast.internal.rest.model.CPGroupModel;
import com.hazelcast.internal.rest.model.CPMemberModel;
import com.hazelcast.internal.rest.model.CPSessionModel;
import com.hazelcast.internal.rest.model.StatusCodeAndMessage;
import com.hazelcast.internal.rest.service.CpService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Collection;
import java.util.UUID;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@RequestMapping(value={"/hazelcast/rest/api/v1/cp"})
@Validated
public class CPController {
    private final CpService cpService;

    public CPController(CpService cpService) {
        this.cpService = cpService;
    }

    @GetMapping(value={"/groups/{group-name}"})
    @Operation(summary="Returns the active CP group with the given name.", description="Endpoint to retrieve the active CP group with the given name. There can be at most one active CP group with a given name.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CPGroupModel.class), examples={@ExampleObject(name="OK", value="{\n  \"cpGroupId\": {\n    \"name\": \"my-cp-group\",\n    \"id\": 320\n  },\n  \"status\": \"ACTIVE\",\n  \"members\": [\n    {\n      \"uuid\": \"e4b7b1b1-1b1b-4b1b-8b1b-1b1b1b1b1b1b\",\n      \"address\": \"10.112.125.2:5701\"\n    },\n    {\n      \"uuid\": \"c4b8b2b2-2a1b-4b1b-8b1b-1b1b1b3c2a2b\",\n      \"address\": \"10.112.125.3:5702\"\n    }\n  ]\n}")})}), @ApiResponse(responseCode="404", description="CP group with provided name could not be found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Not Found", value="{\n  \"statusCode\": 404,\n  \"message\": \"CP group with provided name could not be found.\"\n}")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    DeferredResult<ResponseEntity<CPGroupModel>> getCPGroupByName(@Parameter(in=ParameterIn.PATH, description="Name of the CP group to find", required=true) @PathVariable(value="group-name") String groupName) {
        return this.cpService.getGroupByName(groupName);
    }

    @DeleteMapping(value={"/groups/{group-name}"})
    @Operation(summary="Unconditionally destroys the given active CP group without using the Raft algorithm mechanics.", description="Endpoint to destroy the given active CP group unconditionally.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="CP group is destroyed."), @ApiResponse(responseCode="400", description="Meta data CP group can not be destroyed.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Bad Request", value="{\n  \"statusCode\": 400,\n  \"message\": \"Meta data CP group [METADATA] cannot be destroyed.\"\n}")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    DeferredResult<ResponseEntity<Void>> destroyCPGroupByName(@Parameter(in=ParameterIn.PATH, description="Name of the CP group to destroy", required=true) @PathVariable(value="group-name") String groupName) {
        return this.cpService.destroyGroup(groupName);
    }

    @GetMapping(value={"/groups"})
    @Operation(summary="Retrieve all available CP groups.", description="Endpoint to retrieve all available CP groups in the cluster.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CPGroupIdModel.class)), examples={@ExampleObject(name="OK", value="[\n  {\n    \"name\": \"my-cp-group\",\n    \"id\": 320\n  }\n]")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    DeferredResult<ResponseEntity<Collection<CPGroupIdModel>>> getCPGroups() {
        return this.cpService.getGroups();
    }

    @GetMapping(value={"/members/local"})
    @Operation(summary="Retrieve local CP member.", description="Endpoint to retrieve local CP member in the cluster. Returns the local CP member if the member is part of CP Subsystem, returns 404 response otherwise. Returns 500 response if CP Subsystem is not enabled.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CPMemberModel.class), examples={@ExampleObject(name="OK", value="{\n    \"uuid\": \"11111111-1111-1111-1111-111111111111\",\n    \"address\": \"[10.212.134.155]:5701\"\n}")})}), @ApiResponse(responseCode="404", description="Local member is not part of CP Subsystem.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Not Found", value="{\n  \"statusCode\": 404,\n  \"message\": \"Local member is not part of CP Subsystem.\"\n}")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    CPMemberModel getLocalCPMember() {
        return this.cpService.getLocalCPMember();
    }

    @GetMapping(value={"/members"})
    @Operation(summary="Returns the current list of CP members in the cluster.", description="Endpoint to retrieve the current list of CP members in the cluster. Returns 500 response if CP Subsystem is not enabled.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CPMemberModel.class)), examples={@ExampleObject(name="OK", value="[\n  {\n    \"uuid\": \"11111111-1111-1111-1111-111111111111\",\n    \"address\": \"[10.212.134.155]:5701\"\n  }\n]")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    DeferredResult<ResponseEntity<Collection<CPMemberModel>>> getCPMembers() {
        return this.cpService.getCPMembers();
    }

    @PostMapping(value={"/reset"})
    @Operation(summary="Reset CP Subsystem.", description="Endpoint to reset CP subsystem. It wipes and resets the whole CP Subsystem state and initializes it as if the Hazelcast cluster is starting up initially.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="CP Subsystem is reset."), @ApiResponse(responseCode="500", description="Not enough cluster members to reset CP Subsystem or Current member is not master - only master can reset CP Subsystem.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"Not enough cluster members to reset CP Subsystem!\"\n}")})})})
    DeferredResult<ResponseEntity<Void>> resetCPSubsystem() {
        return this.cpService.resetCPSubsystem();
    }

    @DeleteMapping(value={"/members/{cp-member-uuid}"})
    @Operation(summary="Remove CP member.", description="Endpoint to remove the given unreachable CP member from the active CP members list and all CP groups it belongs to. If any other active CP member is available, it replaces the removed CP member in its CP groups. Otherwise, CP groups which the removed CP member is a member of shrinks and their majority values are recalculated.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="CP member with given uuid is removed."), @ApiResponse(responseCode="400", description="The given CP member is already removed from CP Subsystem or the provided uuid is not valid.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Bad Request", value="{\n  \"statusCode\": 400,\n  \"message\": \"No CPMember found with uuid: 11111111-1111-1111-1111-111111111111\"\n}")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    DeferredResult<ResponseEntity<Void>> removeCPMemberWithUuid(@Parameter(in=ParameterIn.PATH, description="CP member uuid", required=true) @PathVariable(value="cp-member-uuid") UUID cpMemberUuid) {
        return this.cpService.removeCPMember(cpMemberUuid);
    }

    @GetMapping(value={"/groups/{group-name}/sessions"})
    @Operation(summary="Get CP sessions in the given CP group.", description="Endpoint to retrieve a non-null collection of CP sessions that are currently active in the given CP group.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CPSessionModel.class)), examples={@ExampleObject(name="OK", value="[\n  {\n    \"id\": 1,\n    \"creationTime\": 1712834575860,\n    \"expirationTime\": 1712834630874,\n    \"version\": 50,\n    \"endpoint\": \"[192.168.0.24]:5701\",\n    \"endpointType\": \"SERVER\",\n    \"endpointName\": null\n  }\n]")})}), @ApiResponse(responseCode="400", description="The group name provided is either 'METADATA' or an invalid value.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Bad Request", value="{\n  \"statusCode\": 400,\n  \"message\": \"Cannot query CP sessions on the METADATA CP group!\"\n}")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    DeferredResult<ResponseEntity<Collection<CPSessionModel>>> getCPSessions(@Parameter(in=ParameterIn.PATH, description="Name of the CP group", required=true) @PathVariable(value="group-name") String groupName) {
        return this.cpService.getCPSessions(groupName);
    }

    @DeleteMapping(value={"/groups/{group-name}/sessions/{session-id}"})
    @Operation(summary="Close CP session.", description="Endpoint to close a CP session matching the provided group name and session id. If a Hazelcast instance that owns a CP session crashes, its CP session is not terminated immediately. Instead, the session is closed after CPSubsystemConfig.getSessionTimeToLiveSeconds() passes. If it is known for sure that the session owner is not partitioned away and actually crashed, this endpoint can be used for closing the session and releasing its resources immediately.", tags={"CP Controller"}, responses={@ApiResponse(responseCode="200", description="CP session is closed."), @ApiResponse(responseCode="404", description="No session matches with the provided group name or session ID.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Not Found", value="{\n  \"statusCode\": 404,\n  \"message\": \"No session matches with the provided group name or session ID.\"\n}")})}), @ApiResponse(responseCode="500", description="CP subsystem is disabled at the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusCodeAndMessage.class), examples={@ExampleObject(name="Internal Server Error", value="{\n  \"statusCode\": 500,\n  \"message\": \"CP Subsystem is not enabled!\"\n}")})})})
    DeferredResult<ResponseEntity<Void>> closeCPSession(@Parameter(in=ParameterIn.PATH, description="Name of the CP group", required=true) @PathVariable(value="group-name") String groupName, @Parameter(in=ParameterIn.PATH, description="CP session ID", required=true) @PathVariable(value="session-id") Long sessionId) {
        return this.cpService.forceCloseCPSession(groupName, sessionId);
    }
}

