/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.constant;

import com.hazelcast.internal.util.phonehome.EnterprisePhoneHomeMetrics;
import java.util.HashMap;
import java.util.Map;

public class Paths {
    public static final String V1_BASE_PATH = "/hazelcast/rest/api/v1";
    public static final String V1_MEMBER_BASE_PATH = "/hazelcast/rest/api/v1/cluster/members";
    public static final String V1_CP_BASE_PATH = "/hazelcast/rest/api/v1/cp";
    public static final String MEMBER_SELF_PATH = "/self";
    public static final String MEMBER_UUID_PATH = "/{member-uuid}";
    public static final String V1_CLUSTER_BASE_PATH = "/hazelcast/rest/api/v1/cluster";
    public static final String V1_WAN_BASE = "/hazelcast/rest/api/v1/wan";
    public static final String WAN_PROGRESS = "/progress/{uuid}";
    public static final String WAN_SYNC_ALL_MAPS = "/sync-all-maps/{wanReplicationName}/{publisherId}";
    public static final String WAN_SYNC_MAP = "/sync-map/{wanReplicationName}/{publisherId}/{mapName}";
    public static final String WAN_CLEAR_QUEUES = "/clear-queues/{wanReplicationName}/{publisherId}";
    public static final String WAN_STOP_PUBLISHER = "/stop-publisher/{wanReplicationName}/{publisherId}";
    public static final String WAN_RESUME_PUBLISHER = "/resume-publisher/{wanReplicationName}/{publisherId}";
    public static final String WAN_PAUSE_PUBLISHER = "/pause-publisher/{wanReplicationName}/{publisherId}";
    public static final String WAN_ADD_CONFIG = "/add-config";
    public static final String WAN_CONSISTENCY_CHECK = "/map-consistency-check/{wanReplicationName}/{publisherId}/{mapName}";
    public static final String V1_CLUSTER_PERSISTENCE = "/hazelcast/rest/api/v1/cluster/persistence";
    public static final String PERSISTENCE_FORCE_START = "/trigger-force-start";
    public static final String PERSISTENCE_PARTIAL_START = "/trigger-partial-start";
    public static final String PERSISTENCE_BACKUP = "/trigger-backup";
    public static final String PERSISTENCE_BACKUP_INTERRUPT = "/trigger-backup-interrupt";
    public static final String CLUSTER_STATE_PATH = "/state";
    public static final String CLUSTER_VERSION_PATH = "/version";
    public static final String LICENSE_PATH = "/license";
    public static final String LOG_LEVEL_PATH = "/log-level";
    public static final String MEMBER_HEALTH = "/health";
    public static final String MEMBER_READY = "/ready";
    public static final String TOKEN_PATH = "/token";
    public static final String CP_GROUPS_PATH = "/groups";
    public static final String CP_GROUP_BY_NAME_PATH = "/groups/{group-name}";
    public static final String CP_SESSIONS_PATH = "/groups/{group-name}/sessions";
    public static final String CP_SESSION_ID_PATH = "/groups/{group-name}/sessions/{session-id}";
    public static final String CP_MEMBERS_PATH = "/members";
    public static final String CP_LOCAL_MEMBER_PATH = "/members/local";
    public static final String CP_MEMBER_UUID_PATH = "/members/{cp-member-uuid}";
    public static final String CP_RESET_PATH = "/reset";
    public static final String DATA_MAP_BASE = "/hazelcast/rest/api/v1/map";
    public static final String DATA_MAP = "/hazelcast/rest/api/v1/map/{mapName}";
    public static final String DATA_MAP_KEY = "/hazelcast/rest/api/v1/map/{mapName}/{key}";
    public static final String DATA_QUEUE_BASE = "/hazelcast/rest/api/v1/queue";
    public static final String DATA_QUEUE = "/hazelcast/rest/api/v1/queue/{queueName}";
    public static final String DATA_QUEUE_SIZE = "/hazelcast/rest/api/v1/queue/{queueName}/size";
    public static final String CONFIG_BASE_PATH = "/config";
    public static final String CONFIG_RELOAD_PATH = "/config/reload";
    public static final String CONFIG_UPDATE_PATH = "/config/update";
    private static final Map<String, EnterprisePhoneHomeMetrics> PATHS_LOOKUP = new HashMap<String, EnterprisePhoneHomeMetrics>();

    private Paths() {
    }

    public static EnterprisePhoneHomeMetrics pathToPhoneHomeMetrics(String path, String method) {
        Paths.fillPaths();
        return PATHS_LOOKUP.get(method + ":" + path);
    }

    private static void fillPaths() {
        if (!PATHS_LOOKUP.isEmpty()) {
            return;
        }
        Paths.setMemberPaths();
        Paths.setClusterPaths();
        Paths.setWanPaths();
        Paths.setDataPaths();
        Paths.setCPPaths();
    }

    private static void setClusterPaths() {
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster", EnterprisePhoneHomeMetrics.RESTS_GET_CLUSTER_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster/version", EnterprisePhoneHomeMetrics.RESTS_GET_CLUSTER_VERSION_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/version", EnterprisePhoneHomeMetrics.RESTS_POST_CLUSTER_VERSION_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster/state", EnterprisePhoneHomeMetrics.RESTS_GET_CLUSTER_STATE_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/state", EnterprisePhoneHomeMetrics.RESTS_POST_CLUSTER_STATE_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/config/reload", EnterprisePhoneHomeMetrics.RESTS_POST_CONFIG_RELOAD_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster/log-level", EnterprisePhoneHomeMetrics.RESTS_GET_LOG_LEVEL_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/log-level", EnterprisePhoneHomeMetrics.RESTS_POST_LOG_LEVEL_COUNT);
        PATHS_LOOKUP.put("DELETE:/hazelcast/rest/api/v1/cluster/log-level", EnterprisePhoneHomeMetrics.RESTS_DELETE_LOG_LEVEL_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster/license", EnterprisePhoneHomeMetrics.RESTS_GET_LICENSE_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/license", EnterprisePhoneHomeMetrics.RESTS_POST_LICENSE_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/config/update", EnterprisePhoneHomeMetrics.RESTS_POST_CONFIG_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/persistence/trigger-backup", EnterprisePhoneHomeMetrics.RESTS_POST_PERSISTENCE_BACKUP_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/persistence/trigger-force-start", EnterprisePhoneHomeMetrics.RESTS_POST_FORCE_PERSISTENCE_BACKUP_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/persistence/trigger-partial-start", EnterprisePhoneHomeMetrics.RESTS_POST_PARTIAL_PERSISTENCE_BACKUP_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/persistence/trigger-backup-interrupt", EnterprisePhoneHomeMetrics.RESTS_POST_INTERRUPT_PERSISTENCE_BACKUP_COUNT);
    }

    private static void setMemberPaths() {
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster/members", EnterprisePhoneHomeMetrics.RESTS_GET_MEMBERS_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster/members/self", EnterprisePhoneHomeMetrics.RESTS_GET_MEMBER_SELF_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cluster/members/{member-uuid}", EnterprisePhoneHomeMetrics.RESTS_GET_MEMBER_WITH_UUID_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cluster/members", EnterprisePhoneHomeMetrics.RESTS_POST_MEMBERS_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/ready", EnterprisePhoneHomeMetrics.RESTS_GET_MEMBER_READY_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/health", EnterprisePhoneHomeMetrics.RESTS_GET_MEMBER_HEALTH_COUNT);
    }

    private static void setDataPaths() {
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/queue/{queueName}", EnterprisePhoneHomeMetrics.RESTS_POST_QUEUE_COUNT);
        PATHS_LOOKUP.put("DELETE:/hazelcast/rest/api/v1/queue/{queueName}", EnterprisePhoneHomeMetrics.RESTS_DELETE_QUEUE_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/queue/{queueName}/size", EnterprisePhoneHomeMetrics.RESTS_GET_QUEUE_SIZE_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/map/{mapName}/{key}", EnterprisePhoneHomeMetrics.RESTS_GET_MAP_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/map/{mapName}/{key}", EnterprisePhoneHomeMetrics.RESTS_POST_MAP_COUNT);
        PATHS_LOOKUP.put("DELETE:/hazelcast/rest/api/v1/map/{mapName}/{key}", EnterprisePhoneHomeMetrics.RESTS_DELETE_MAP_COUNT);
        PATHS_LOOKUP.put("DELETE:/hazelcast/rest/api/v1/map/{mapName}", EnterprisePhoneHomeMetrics.RESTS_DELETE_MAP_STRUCTURE_COUNT);
    }

    private static void setCPPaths() {
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/cp/reset", EnterprisePhoneHomeMetrics.RESTS_POST_CP_RESET_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cp/members", EnterprisePhoneHomeMetrics.RESTS_GET_CP_MEMBERS_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cp/members/local", EnterprisePhoneHomeMetrics.RESTS_GET_CP_LOCAL_MEMBER_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cp/groups", EnterprisePhoneHomeMetrics.RESTS_GET_CP_GROUPS_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cp/groups/{group-name}", EnterprisePhoneHomeMetrics.RESTS_GET_CP_GROUP_BY_NAME_COUNT);
        PATHS_LOOKUP.put("DELETE:/hazelcast/rest/api/v1/cp/groups/{group-name}", EnterprisePhoneHomeMetrics.RESTS_DELETE_CP_GROUP_BY_NAME_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/cp/groups/{group-name}/sessions", EnterprisePhoneHomeMetrics.RESTS_GET_CP_SESSIONS_COUNT);
        PATHS_LOOKUP.put("DELETE:/hazelcast/rest/api/v1/cp/members/{cp-member-uuid}", EnterprisePhoneHomeMetrics.RESTS_DELETE_CP_MEMBER_BY_UUID_COUNT);
        PATHS_LOOKUP.put("DELETE:/hazelcast/rest/api/v1/cp/groups/{group-name}/sessions/{session-id}", EnterprisePhoneHomeMetrics.RESTS_DELETE_CP_SESSION_COUNT);
    }

    private static void setWanPaths() {
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/sync-map/{wanReplicationName}/{publisherId}/{mapName}", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_SYNC_MAP_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/sync-all-maps/{wanReplicationName}/{publisherId}", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_SYNC_ALL_MAPS_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/stop-publisher/{wanReplicationName}/{publisherId}", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_STOP_PUBLISHER_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/resume-publisher/{wanReplicationName}/{publisherId}", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_RESUME_PUBLISHER_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/pause-publisher/{wanReplicationName}/{publisherId}", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_PAUSE_PUBLISHER_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/map-consistency-check/{wanReplicationName}/{publisherId}/{mapName}", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_CONSISTENCY_CHECK_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/clear-queues/{wanReplicationName}/{publisherId}", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_CLEAR_QUEUES_COUNT);
        PATHS_LOOKUP.put("POST:/hazelcast/rest/api/v1/wan/add-config", EnterprisePhoneHomeMetrics.RESTS_POST_WAN_ADD_CONFIG_COUNT);
        PATHS_LOOKUP.put("GET:/hazelcast/rest/api/v1/wan/progress/{uuid}", EnterprisePhoneHomeMetrics.RESTS_GET_WAN_PROGRESS_COUNT);
    }
}

