/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.access;

import com.hazelcast.rest.access.RestAuthenticationContext;
import java.net.InetAddress;

public class SimpleAuthenticationContext
implements RestAuthenticationContext {
    private final String clusterName;
    private final String username;
    private final String password;
    private final byte[] token;
    private final InetAddress remoteAddress;

    private SimpleAuthenticationContext(Builder builder) {
        this.clusterName = builder.clusterName;
        this.username = builder.username;
        this.password = builder.password;
        this.token = builder.token;
        this.remoteAddress = builder.remoteAddress;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public byte[] getToken() {
        return this.token;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String clusterName;
        private String username;
        private String password;
        private byte[] token;
        private InetAddress remoteAddress;

        private Builder() {
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withToken(byte[] token) {
            this.token = token;
            return this;
        }

        public Builder withRemoteAddress(InetAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public SimpleAuthenticationContext build() {
            return new SimpleAuthenticationContext(this);
        }
    }
}

