/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.rest.access;

import com.hazelcast.access.AccessControlService;
import com.hazelcast.access.AccessControlServiceFactory;
import com.hazelcast.internal.rest.access.DefaultAccessControlService;
import com.hazelcast.security.SecurityContextCallback;
import com.hazelcast.security.impl.PropertyCallback;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;

public class DefaultAccessControlServiceFactory
implements AccessControlServiceFactory {
    public static final String PROPERTY_AUTHENTICATION_REALM = "authenticationRealm";
    private volatile CallbackHandler callbackHandler;
    private volatile String authenticationRealm;

    public void init(CallbackHandler callbackHandler, Properties properties) {
        this.callbackHandler = callbackHandler;
        this.authenticationRealm = properties.getProperty(PROPERTY_AUTHENTICATION_REALM);
    }

    public AccessControlService createAccessControlService() throws Exception {
        SecurityContextCallback ssCb = new SecurityContextCallback();
        PropertyCallback currentRealmCb = new PropertyCallback("currentRealm");
        this.callbackHandler.handle(new Callback[]{ssCb, currentRealmCb});
        return new DefaultAccessControlService(ssCb.getSecurityContext(), this.authenticationRealm != null ? this.authenticationRealm : currentRealmCb.getPropertyValue());
    }
}

