/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.selector;

import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.selector.ServerSelector;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@ThreadSafe
public final class MinimumOperationCountServerSelector
implements ServerSelector {
    private final Cluster.ServersSnapshot serversSnapshot;

    public MinimumOperationCountServerSelector(Cluster.ServersSnapshot serversSnapshot) {
        this.serversSnapshot = serversSnapshot;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        return clusterDescription.getServerDescriptions().stream().min(Comparator.comparingInt(serverDescription -> Assertions.assertNotNull(this.serversSnapshot.getServer(serverDescription.getAddress())).operationCount())).map(Collections::singletonList).orElse(Collections.emptyList());
    }
}

