/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.internal.async.AsyncConsumer;
import com.mongodb.internal.async.AsyncFunction;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

@FunctionalInterface
public interface AsyncSupplier<T>
extends AsyncFunction<Void, T> {
    public void unsafeFinish(SingleResultCallback<T> var1);

    default public void getAsync(SingleResultCallback<T> callback) {
        this.finish(callback);
    }

    @Override
    default public void unsafeFinish(@Nullable Void value, SingleResultCallback<T> callback) {
        this.unsafeFinish(callback);
    }

    default public void finish(SingleResultCallback<T> callback) {
        AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        try {
            this.unsafeFinish((v, e) -> {
                if (!callbackInvoked.compareAndSet(false, true)) {
                    throw new AssertionError(String.format("Callback has been already completed. It could happen if code throws an exception after invoking an async method. Value: %s", v), e);
                }
                callback.onResult(v, e);
            });
        }
        catch (Throwable t2) {
            if (!callbackInvoked.compareAndSet(false, true)) {
                throw t2;
            }
            callback.completeExceptionally(t2);
        }
    }

    default public void thenRunAndFinish(Runnable runnable, SingleResultCallback<T> callback) {
        this.finish((r, e) -> {
            if (e != null) {
                callback.completeExceptionally(e);
                return;
            }
            try {
                runnable.run();
            }
            catch (Throwable t2) {
                callback.completeExceptionally(t2);
                return;
            }
            callback.onResult(r, null);
        });
    }

    default public void thenAlwaysRunAndFinish(Runnable runnable, SingleResultCallback<T> callback) {
        this.finish((r, e) -> {
            try {
                runnable.run();
            }
            catch (Throwable t2) {
                if (e != null) {
                    t2.addSuppressed(e);
                }
                callback.completeExceptionally(t2);
                return;
            }
            callback.onResult(r, e);
        });
    }

    default public <R> AsyncSupplier<R> thenApply(AsyncFunction<T, R> function) {
        return c -> this.finish((v, e) -> {
            if (e == null) {
                function.finish(v, c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public AsyncRunnable thenConsume(AsyncConsumer<T> consumer) {
        return c -> this.unsafeFinish((v, e) -> {
            if (e == null) {
                consumer.finish(v, c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public AsyncSupplier<T> onErrorIf(Predicate<Throwable> errorCheck, AsyncFunction<Throwable, T> errorFunction) {
        return callback -> this.finish((r, e) -> {
            boolean errorMatched;
            if (e == null) {
                callback.complete(r);
                return;
            }
            try {
                errorMatched = errorCheck.test(e);
            }
            catch (Throwable t2) {
                t2.addSuppressed(e);
                callback.completeExceptionally(t2);
                return;
            }
            if (errorMatched) {
                errorFunction.finish(e, callback);
            } else {
                callback.completeExceptionally(e);
            }
        });
    }
}

