/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.SslHelper;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class KeyManagementService {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    private final int timeoutMillis;

    KeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap, int timeoutMillis) {
        this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", kmsProviderSslContextMap);
        this.timeoutMillis = timeoutMillis;
    }

    public InputStream stream(String kmsProvider, String host, ByteBuffer message, @Nullable Timeout operationTimeout) throws IOException {
        ServerAddress serverAddress = new ServerAddress(host);
        LOGGER.info("Connecting to KMS server at " + serverAddress);
        SSLContext sslContext = this.kmsProviderSslContextMap.get(kmsProvider);
        SocketFactory sslSocketFactory = sslContext == null ? SSLSocketFactory.getDefault() : sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket();
        this.enableHostNameVerification(socket);
        try {
            socket.setSoTimeout(this.timeoutMillis);
            socket.connect(new InetSocketAddress(InetAddress.getByName(serverAddress.getHost()), serverAddress.getPort()), this.timeoutMillis);
        }
        catch (IOException e) {
            this.closeSocket(socket);
            throw e;
        }
        try {
            OutputStream outputStream = socket.getOutputStream();
            byte[] bytes = new byte[message.remaining()];
            message.get(bytes);
            outputStream.write(bytes);
        }
        catch (IOException e) {
            this.closeSocket(socket);
            throw e;
        }
        try {
            return OperationTimeoutAwareInputStream.wrapIfNeeded(operationTimeout, socket);
        }
        catch (IOException e) {
            this.closeSocket(socket);
            throw e;
        }
    }

    private void enableHostNameVerification(SSLSocket socket) {
        SSLParameters sslParameters = socket.getSSLParameters();
        if (sslParameters == null) {
            sslParameters = new SSLParameters();
        }
        SslHelper.enableHostNameVerification(sslParameters);
        socket.setSSLParameters(sslParameters);
    }

    private void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }

    private static final class OperationTimeoutAwareInputStream
    extends InputStream {
        private final Socket socket;
        private final Timeout operationTimeout;
        private final InputStream wrapped;

        private OperationTimeoutAwareInputStream(Socket socket, Timeout operationTimeout) throws IOException {
            this.socket = socket;
            this.operationTimeout = operationTimeout;
            this.wrapped = socket.getInputStream();
        }

        public static InputStream wrapIfNeeded(@Nullable Timeout operationTimeout, SSLSocket socket) throws IOException {
            return Timeout.nullAsInfinite(operationTimeout).checkedCall(TimeUnit.NANOSECONDS, () -> socket.getInputStream(), ns -> new OperationTimeoutAwareInputStream(socket, Assertions.assertNotNull(operationTimeout)), () -> new OperationTimeoutAwareInputStream(socket, Assertions.assertNotNull(operationTimeout)));
        }

        private void setSocketSoTimeoutToOperationTimeout() throws SocketException {
            this.operationTimeout.checkedRun(TimeUnit.MILLISECONDS, () -> {
                throw new AssertionError((Object)"operationTimeout cannot be infinite");
            }, ms -> this.socket.setSoTimeout(Math.toIntExact(ms)), () -> TimeoutContext.throwMongoTimeoutException("Reading from KMS server exceeded the timeout limit."));
        }

        @Override
        public int read() throws IOException {
            this.setSocketSoTimeoutToOperationTimeout();
            return this.wrapped.read();
        }

        @Override
        public int read(@NonNull byte[] b) throws IOException {
            this.setSocketSoTimeoutToOperationTimeout();
            return this.wrapped.read(b);
        }

        @Override
        public int read(@NonNull byte[] b, int off, int len) throws IOException {
            this.setSocketSoTimeoutToOperationTimeout();
            return this.wrapped.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public long skip(long n) throws IOException {
            this.setSocketSoTimeoutToOperationTimeout();
            return this.wrapped.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }
}

