/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.mongodb.MongoSinkBuilder;
import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.mongodb.impl.UpdateMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicallyReplacedPlaceholder;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.jet.sql.impl.connector.mongodb.PlaceholderReplacer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.mongodb.TransactionOptions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.WriteModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateProcessorSupplier
extends MongoProcessorSupplier
implements DataSerializable {
    private String[] updatedFieldNames;
    private List<? extends Serializable> updates;
    private boolean afterScan;
    private ExpressionEvalContext evalContext;
    private String pkExternalName;
    private Serializable predicate;

    public UpdateProcessorSupplier() {
    }

    UpdateProcessorSupplier(MongoTable table, @Nonnull String[] updatedFieldNames, List<? extends Serializable> updates, Serializable predicate, boolean hasInput) {
        super(table);
        this.updatedFieldNames = updatedFieldNames;
        this.updates = updates;
        this.pkExternalName = table.primaryKeyExternalName();
        this.predicate = predicate;
        this.afterScan = hasInput;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        if (this.connectionString != null) {
            this.clientSupplier = (SupplierEx & Serializable)() -> MongoClients.create(this.connectionString);
        }
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Processor[] processors = new Processor[count];
        if (!this.afterScan) {
            Document predicateWithReplacements = this.predicate == null ? MongoUtilities.UPDATE_ALL_PREDICATE : DynamicallyReplacedPlaceholder.replacePlaceholdersInPredicate(this.predicate, this.externalNames, this.evalContext);
            for (int i = 0; i < count; ++i) {
                UpdateMongoP<Document> processor = new UpdateMongoP<Document>(new WriteMongoParams().setClientSupplier((SupplierEx<MongoClient>)this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class).setCheckExistenceOnEachConnect(this.checkExistenceOnEachConnect), this.writeModelNoScan(predicateWithReplacements));
                processors[i] = processor;
            }
            return Arrays.asList(processors);
        }
        for (int i = 0; i < count; ++i) {
            WriteMongoP processor = new WriteMongoP(new WriteMongoParams().setClientSupplier((SupplierEx<MongoClient>)this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class).setCommitRetryStrategy(MongoSinkBuilder.DEFAULT_COMMIT_RETRY_STRATEGY).setTransactionOptionsSup((SupplierEx<TransactionOptions>)(SupplierEx & Serializable)() -> MongoSinkBuilder.DEFAULT_TRANSACTION_OPTION).setIntermediateMappingFn(this::rowToUpdateDoc).setWriteModelFn((FunctionEx<Document, WriteModel<Document>>)((FunctionEx & Serializable)this::writeModelAfterScan)).setCheckExistenceOnEachConnect(this.checkExistenceOnEachConnect));
            processors[i] = processor;
        }
        return Arrays.asList(processors);
    }

    private SupplierEx<WriteModel<Document>> writeModelNoScan(Document predicate) {
        return (SupplierEx & Serializable)() -> {
            Document values = this.valuesToUpdateDoc(this.externalNames);
            List pipeline = (List)((Object)values.get((Object)"update", List.class));
            UpdateManyModel doc = new UpdateManyModel((Bson)predicate, pipeline);
            return doc;
        };
    }

    private WriteModel<Document> writeModelAfterScan(Document update) {
        List updates = Objects.requireNonNull((List)((Object)update.get((Object)"update", List.class)), "updateList");
        Bson filter = Objects.requireNonNull((Bson)((Object)update.get((Object)"filter", Bson.class)));
        return new UpdateManyModel<Document>(filter, updates);
    }

    private Document rowToUpdateDoc(JetSqlRow row) {
        Object[] values = row.getValues();
        return this.valuesToUpdateDoc(values);
    }

    private Document valuesToUpdateDoc(Object[] values) {
        Object pkValue = values[0];
        ArrayList<Bson> updateToPerform = new ArrayList<Bson>();
        for (int i = 0; i < this.updatedFieldNames.length; ++i) {
            String fieldName = this.updatedFieldNames[i];
            Serializable updateExpr = this.updates.get(i);
            if (updateExpr instanceof Bson) {
                Document document = Document.parse(((Bson)((Object)updateExpr)).toBsonDocument(Document.class, Mappers.defaultCodecRegistry()).toJson());
                PlaceholderReplacer.replacePlaceholders(document, this.evalContext, values, this.externalNames, this.afterScan);
                updateExpr = document;
                updateToPerform.add(Aggregates.set(new Field<Serializable>(fieldName, updateExpr)));
                continue;
            }
            if (updateExpr instanceof String) {
                String expr = (String)((Object)updateExpr);
                Object withReplacements = PlaceholderReplacer.replace(expr, this.evalContext, values, this.externalNames, false, this.afterScan);
                updateToPerform.add(Aggregates.set(new Field<Object>(fieldName, withReplacements)));
                continue;
            }
            updateToPerform.add(Aggregates.set(new Field<Serializable>(fieldName, updateExpr)));
        }
        Bson filter = Filters.eq(this.pkExternalName, pkValue);
        return new Document("filter", filter).append("update", updateToPerform);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.connectionString);
        out.writeString(this.databaseName);
        out.writeString(this.collectionName);
        out.writeStringArray(this.updatedFieldNames);
        out.writeObject(this.updates);
        out.writeString(this.dataConnectionName);
        out.writeStringArray(this.externalNames);
        out.writeBoolean(this.afterScan);
        out.writeString(this.pkExternalName);
        out.writeObject((Object)this.predicate);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.connectionString = in.readString();
        this.databaseName = in.readString();
        this.collectionName = in.readString();
        this.updatedFieldNames = in.readStringArray();
        this.updates = (List)in.readObject();
        this.dataConnectionName = in.readString();
        this.externalNames = in.readStringArray();
        this.afterScan = in.readBoolean();
        this.pkExternalName = in.readString();
        this.predicate = (Serializable)in.readObject();
    }
}

