/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicallyReplacedPlaceholder;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class InputRef
implements DynamicallyReplacedPlaceholder {
    private static final Pattern PATTERN = Pattern.compile("<!InputRef\\((\\d+)\\)!>");
    private final int inputIndex;

    public InputRef(int inputIndex) {
        this.inputIndex = inputIndex;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    @Override
    @Nonnull
    public String asString() {
        return "<!InputRef(" + this.inputIndex + ")!>";
    }

    public static InputRef match(Object o) {
        Matcher matcher;
        if (o instanceof String && (matcher = PATTERN.matcher((String)o)).matches()) {
            return new InputRef(Integer.parseInt(matcher.group(1)));
        }
        return null;
    }

    public static boolean matches(Object o) {
        if (o instanceof String) {
            Matcher matcher = PATTERN.matcher((String)o);
            return matcher.matches();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputRef)) {
            return false;
        }
        InputRef inputRef = (InputRef)o;
        return this.inputIndex == inputRef.inputIndex;
    }

    public int hashCode() {
        return Objects.hash(this.inputIndex);
    }

    public String toString() {
        return "InputRef(" + this.inputIndex + ")";
    }
}

