/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.types.Decimal128;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public final class ConversionsToBson {
    private static final int HEX_RADIX = 16;

    private ConversionsToBson() {
    }

    public static Object convertToBson(Object value, QueryDataType sqlType, BsonType bsonType) {
        if (value == null) {
            return null;
        }
        Object converted = null;
        switch (bsonType) {
            case OBJECT_ID: {
                converted = ConversionsToBson.convertToObjectId(value);
                break;
            }
            case ARRAY: {
                converted = ConversionsToBson.convertToArray(value);
                break;
            }
            case BOOLEAN: {
                converted = ConversionsToBson.convertToBoolean(value);
                break;
            }
            case DATE_TIME: {
                converted = ConversionsToBson.convertToDateTime(value);
                break;
            }
            case TIMESTAMP: {
                converted = ConversionsToBson.convertToTimestamp(value);
                break;
            }
            case INT32: {
                converted = ConversionsToBson.convertToInt(value);
                break;
            }
            case INT64: {
                converted = ConversionsToBson.convertToLong(value);
                break;
            }
            case DOUBLE: {
                converted = ConversionsToBson.convertToDouble(value);
                break;
            }
            case DECIMAL128: {
                converted = ConversionsToBson.convertToBigDecimal(value);
                break;
            }
            case DOCUMENT: {
                converted = ConversionsToBson.convertToDocument(value);
                break;
            }
            case JAVASCRIPT: {
                converted = ConversionsToBson.convertToJavaScript(value);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                converted = ConversionsToBson.convertToJavaScriptWithScope(value);
                break;
            }
            case STRING: {
                converted = ConversionsToBson.convertToString(value);
                break;
            }
            case REGULAR_EXPRESSION: {
                converted = ConversionsToBson.convertToRegEx(value);
                break;
            }
            case MIN_KEY: {
                converted = ConversionsToBson.convertToMinKey(value);
                break;
            }
            case MAX_KEY: {
                converted = ConversionsToBson.convertToMaxKey(value);
                break;
            }
        }
        if (converted == null) {
            return sqlType.convert(value);
        }
        return converted;
    }

    private static Object convertToDateTime(Object value) {
        if (value instanceof BsonDateTime) {
            return value;
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return LocalDateTime.ofEpochSecond(integer.intValue(), 0, ZoneOffset.UTC);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(longValue), ZoneOffset.UTC);
        }
        if (value instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value;
            return LocalDateTime.parse(charSequence);
        }
        if (value instanceof BsonString) {
            BsonString bsonString = (BsonString)value;
            return LocalDateTime.parse(bsonString.getValue());
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return new BsonDateTime(localDateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
            return new BsonDateTime(zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            return new BsonDateTime(offsetDateTime.atZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        return null;
    }

    private static BsonTimestamp convertToTimestamp(Object value) {
        if (value instanceof BsonTimestamp) {
            BsonTimestamp bsonTimestamp = (BsonTimestamp)value;
            return bsonTimestamp;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new BsonTimestamp(number.longValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            return new BsonTimestamp(Long.parseLong(string));
        }
        if (value instanceof BsonString) {
            BsonString bsonString = (BsonString)value;
            return new BsonTimestamp(Long.parseLong(bsonString.getValue()));
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return new BsonTimestamp((int)localDateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toEpochSecond(), 0);
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
            return new BsonTimestamp((int)zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toEpochSecond(), 0);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            return new BsonTimestamp((int)offsetDateTime.atZoneSameInstant(ZoneOffset.UTC).toEpochSecond(), 0);
        }
        return null;
    }

    private static ObjectId convertToObjectId(Object value) {
        if (value instanceof ObjectId) {
            ObjectId objectId = (ObjectId)value;
            return objectId;
        }
        if (value instanceof String) {
            String string = (String)value;
            return new ObjectId(string);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return new ObjectId(Integer.toHexString(integer));
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return new ObjectId(Long.toHexString(longValue));
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return new ObjectId(bigDecimal.toBigInteger().toString(16));
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return new ObjectId(bigInteger.toString(16));
        }
        return null;
    }

    private static Collection<?> convertToArray(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    private static Boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        if (value instanceof String) {
            String string = (String)value;
            return Boolean.parseBoolean(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue() > 0.0;
        }
        return null;
    }

    private static Integer convertToInt(Object value) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer;
        }
        if (value instanceof BsonInt32) {
            BsonInt32 bsonInt32 = (BsonInt32)value;
            return bsonInt32.getValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            return Integer.parseInt(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return null;
    }

    private static Long convertToLong(Object value) {
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof BsonInt64) {
            BsonInt64 bsonInt64 = (BsonInt64)value;
            return bsonInt64.getValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            return Long.parseLong(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return null;
    }

    private static Double convertToDouble(Object value) {
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return doubleValue;
        }
        if (value instanceof BsonDouble) {
            BsonDouble bsonDouble = (BsonDouble)value;
            return bsonDouble.getValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            return Double.parseDouble(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return null;
    }

    private static Object convertToBigDecimal(Object value) {
        if (value instanceof BigDecimal || value instanceof BsonDecimal128 || value instanceof Decimal128) {
            return value;
        }
        if (value instanceof String) {
            String string = (String)value;
            return new BigDecimal(string);
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        return null;
    }

    private static Document convertToDocument(Object value) {
        if (value instanceof Document) {
            Document document = (Document)value;
            return document;
        }
        if (value instanceof String) {
            String string = (String)value;
            return Document.parse(string);
        }
        if (value instanceof BsonString) {
            BsonString bsonString = (BsonString)value;
            return Document.parse(bsonString.getValue());
        }
        if (value instanceof HazelcastJsonValue) {
            HazelcastJsonValue hazelcastJsonValue = (HazelcastJsonValue)value;
            return Document.parse(hazelcastJsonValue.getValue());
        }
        if (value instanceof Map) {
            return new Document((Map)value);
        }
        return null;
    }

    private static BsonJavaScript convertToJavaScript(Object value) {
        if (value instanceof BsonJavaScript) {
            BsonJavaScript bsonJavaScript = (BsonJavaScript)value;
            return bsonJavaScript;
        }
        if (value instanceof String) {
            String string = (String)value;
            return new BsonJavaScript(string);
        }
        return null;
    }

    private static BsonJavaScriptWithScope convertToJavaScriptWithScope(Object value) {
        if (value instanceof BsonJavaScriptWithScope) {
            BsonJavaScriptWithScope bsonJavaScriptWithScope = (BsonJavaScriptWithScope)value;
            return bsonJavaScriptWithScope;
        }
        if (value instanceof Document) {
            Document doc = (Document)value;
            return new BsonJavaScriptWithScope(doc.getString("code"), (BsonDocument)doc.get("scope"));
        }
        if (value instanceof BsonDocument) {
            BsonDocument doc = (BsonDocument)value;
            return new BsonJavaScriptWithScope(doc.getString("code").toString(), (BsonDocument)doc.get("scope"));
        }
        return null;
    }

    private static String convertToString(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        if (value instanceof BsonString) {
            BsonString bsonString = (BsonString)value;
            return bsonString.getValue();
        }
        if (value instanceof BsonJavaScript) {
            BsonJavaScript bsonJavaScript = (BsonJavaScript)value;
            return bsonJavaScript.getCode();
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            return document.toJson();
        }
        if (value instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)value;
            return bsonDocument.toJson();
        }
        if (value instanceof BsonJavaScriptWithScope) {
            BsonJavaScriptWithScope bsonJavaScriptWithScope = (BsonJavaScriptWithScope)value;
            Document doc = new Document();
            doc.put("code", (Object)bsonJavaScriptWithScope.getCode());
            doc.put("scope", (Object)bsonJavaScriptWithScope.getScope());
            return doc.toJson();
        }
        return value.toString();
    }

    private static BsonRegularExpression convertToRegEx(Object value) {
        if (value instanceof BsonRegularExpression) {
            BsonRegularExpression bsonRegularExpression = (BsonRegularExpression)value;
            return bsonRegularExpression;
        }
        if (value instanceof String) {
            String string = (String)value;
            return new BsonRegularExpression(string);
        }
        return null;
    }

    private static MinKey convertToMinKey(Object value) {
        String string;
        if (value instanceof MinKey) {
            MinKey minKey = (MinKey)value;
            return minKey;
        }
        if (value instanceof BsonMinKey) {
            return new MinKey();
        }
        if (value instanceof String && "Minkey".equalsIgnoreCase(string = (String)value)) {
            return new MinKey();
        }
        return null;
    }

    private static MaxKey convertToMaxKey(Object value) {
        String string;
        if (value instanceof MaxKey) {
            MaxKey maxKey = (MaxKey)value;
            return maxKey;
        }
        if (value instanceof BsonMaxKey) {
            return new MaxKey();
        }
        if (value instanceof String && "MaxKey".equalsIgnoreCase(string = (String)value)) {
            return new MaxKey();
        }
        return null;
    }
}

