/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.dataconnection;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.mongodb.dataconnection.MongoDataConnection;
import com.mongodb.connection.SslSettings;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class SslConf {
    public static final String ENABLE_SSL = "enableSsl";
    public static final String INVALID_HOSTNAME_ALLOWED = "invalidHostNameAllowed";
    public static final String KEYSTORE_LOCATION = "keyStore";
    public static final String KEYSTORE_TYPE = "keyStoreType";
    public static final String KEYSTORE_PASSWORD = "keyStorePassword";
    public static final String TRUSTSTORE_LOCATION = "trustStore";
    public static final String TRUSTSTORE_TYPE = "trustStoreType";
    public static final String TRUSTSTORE_PASSWORD = "trustStorePassword";
    private final boolean enableSsl;
    private final boolean invalidHostNameAllowed;
    private final String keyStoreLocation;
    private final String keyStoreType;
    private final String keyStorePassword;
    private final String trustStoreLocation;
    private final String trustStoreType;
    private final String trustStorePassword;

    SslConf(DataConnectionConfig config) {
        this.enableSsl = Boolean.parseBoolean(config.getProperty(ENABLE_SSL, "false"));
        this.invalidHostNameAllowed = Boolean.parseBoolean(config.getProperty(INVALID_HOSTNAME_ALLOWED, "false"));
        this.keyStoreLocation = config.getProperty(KEYSTORE_LOCATION);
        this.keyStoreType = config.getProperty(KEYSTORE_TYPE);
        this.keyStorePassword = config.getProperty(KEYSTORE_PASSWORD);
        this.trustStoreLocation = config.getProperty(TRUSTSTORE_LOCATION);
        this.trustStoreType = config.getProperty(TRUSTSTORE_TYPE);
        this.trustStorePassword = config.getProperty(TRUSTSTORE_PASSWORD);
        Preconditions.checkState((boolean)MongoDataConnection.allSame(this.keyStoreLocation == null, this.keyStorePassword == null), (String)"KeyStore configuration is not full, you must provide both keyStore location and password");
        Preconditions.checkState((boolean)MongoDataConnection.allSame(this.trustStoreLocation == null, this.trustStorePassword == null), (String)"KeyStore configuration is not full, you must provide both trustStore location and password");
    }

    public void apply(SslSettings.Builder builder) {
        builder.enabled(this.enableSsl);
        builder.invalidHostNameAllowed(this.invalidHostNameAllowed);
        if (this.keyStoreLocation != null || this.trustStoreLocation != null) {
            char[] ksPass = this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray();
            char[] tsPass = this.trustStorePassword == null ? null : this.trustStorePassword.toCharArray();
            SSLContext sslContext = SslConf.createSSLContext(this.keyStoreLocation, this.keyStoreType, ksPass, this.trustStoreLocation, this.trustStoreType, tsPass);
            builder.context(sslContext);
        }
    }

    static SSLContext createSSLContext(String ksFile, String ksType, char[] ksPass, String tsFile, String tsType, char[] tsPass) {
        try {
            KeyStore keyStore = SslConf.loadKeystore(ksFile, ksType, ksPass);
            KeyManagerFactory keyManagerFactory = null;
            if (keyStore != null) {
                keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
                keyManagerFactory.init(keyStore, ksPass);
            }
            KeyStore trustStore = SslConf.loadKeystore(tsFile, tsType, tsPass);
            TrustManagerFactory trustManagerFactory = null;
            if (trustStore != null) {
                trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                trustManagerFactory.init(trustStore);
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyManager[] keyManagers = keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers();
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot configure SSL", e);
        }
    }

    private static KeyStore loadKeystore(String ksFile, String ksType, char[] ksPass) throws IOException, GeneralSecurityException {
        if (ksFile == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(ksType == null ? KeyStore.getDefaultType() : ksType);
        try (FileInputStream stream = new FileInputStream(ksFile);){
            ks.load(stream, ksPass);
        }
        return ks;
    }
}

