/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.dataconnection;

import com.mongodb.ClientBulkWriteException;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCluster;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.connection.ClusterDescription;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class CloseableMongoClient
implements MongoClient {
    final MongoClient delegate;
    private final Runnable onClose;

    CloseableMongoClient(MongoClient delegate, Runnable onClose) {
        this.delegate = delegate;
        this.onClose = onClose;
    }

    MongoClient unwrap() {
        return this.delegate;
    }

    @Override
    public void close() {
        this.onClose.run();
    }

    @Override
    @Nonnull
    public MongoDatabase getDatabase(@Nonnull String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    @Nonnull
    public ClientSession startSession() {
        return this.delegate.startSession();
    }

    @Override
    @Nonnull
    public ClientSession startSession(@Nonnull ClientSessionOptions options) {
        return this.delegate.startSession(options);
    }

    @Override
    @Nonnull
    public MongoIterable<String> listDatabaseNames() {
        return this.delegate.listDatabaseNames();
    }

    @Override
    @Nonnull
    public MongoIterable<String> listDatabaseNames(@Nonnull ClientSession clientSession) {
        return this.delegate.listDatabaseNames(clientSession);
    }

    @Override
    @Nonnull
    public ListDatabasesIterable<Document> listDatabases() {
        return this.delegate.listDatabases();
    }

    @Override
    @Nonnull
    public ListDatabasesIterable<Document> listDatabases(@Nonnull ClientSession clientSession) {
        return this.delegate.listDatabases(clientSession);
    }

    @Override
    @Nonnull
    public <TResult> ListDatabasesIterable<TResult> listDatabases(@Nonnull Class<TResult> tResultClass) {
        return this.delegate.listDatabases(tResultClass);
    }

    @Override
    @Nonnull
    public <TResult> ListDatabasesIterable<TResult> listDatabases(@Nonnull ClientSession clientSession, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.listDatabases(clientSession, tResultClass);
    }

    @Override
    @Nonnull
    public ChangeStreamIterable<Document> watch() {
        return this.delegate.watch();
    }

    @Override
    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(tResultClass);
    }

    @Override
    @Nonnull
    public ChangeStreamIterable<Document> watch(@Nonnull List<? extends Bson> pipeline) {
        return this.delegate.watch(pipeline);
    }

    @Override
    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull List<? extends Bson> pipeline, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(pipeline, tResultClass);
    }

    @Override
    @Nonnull
    public ChangeStreamIterable<Document> watch(@Nonnull ClientSession clientSession) {
        return this.delegate.watch(clientSession);
    }

    @Override
    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull ClientSession clientSession, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(clientSession, tResultClass);
    }

    @Override
    @Nonnull
    public ChangeStreamIterable<Document> watch(@Nonnull ClientSession clientSession, @Nonnull List<? extends Bson> pipeline) {
        return this.delegate.watch(clientSession, pipeline);
    }

    @Override
    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull ClientSession clientSession, @Nonnull List<? extends Bson> pipeline, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(clientSession, pipeline, tResultClass);
    }

    @Override
    @Nonnull
    public ClusterDescription getClusterDescription() {
        return this.delegate.getClusterDescription();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.delegate.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.delegate.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.delegate.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        return this.delegate.getTimeout(timeUnit);
    }

    @Override
    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return this.delegate.withCodecRegistry(codecRegistry);
    }

    @Override
    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return this.delegate.withReadPreference(readPreference);
    }

    @Override
    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return this.delegate.withWriteConcern(writeConcern);
    }

    @Override
    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return this.delegate.withReadConcern(readConcern);
    }

    @Override
    public MongoCluster withTimeout(long timeout, TimeUnit timeUnit) {
        return this.delegate.withTimeout(timeout, timeUnit);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> models) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(models);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> models, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(models, options);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> models) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(clientSession, models);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> models, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        return this.delegate.bulkWrite(clientSession, models, options);
    }
}

