/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.mongodb.ResourceChecks;
import com.hazelcast.jet.mongodb.impl.DbCheckingPMetaSupplierBuilder;
import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.mongodb.impl.ReadMongoP;
import com.hazelcast.jet.mongodb.impl.ReadMongoParams;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class MongoSourceBuilder {
    private MongoSourceBuilder() {
    }

    @Nonnull
    public static Batch<Document> batch(@Nonnull String name, @Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
        return new Batch<Document>(name, clientSupplier);
    }

    @Nonnull
    public static Batch<Document> batch(@Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
        return MongoSourceBuilder.batch("MongoBatchSource", clientSupplier);
    }

    @Nonnull
    public static Batch<Document> batch(@Nonnull String name, @Nonnull DataConnectionRef dataConnectionRef) {
        return new Batch<Document>(name, dataConnectionRef);
    }

    @Nonnull
    public static Batch<Document> batch(@Nonnull DataConnectionRef dataConnectionRef) {
        return new Batch<Document>("MongoBatchSource(" + dataConnectionRef.getName() + ")", dataConnectionRef);
    }

    @Nonnull
    public static Stream<Document> stream(@Nonnull String name, @Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
        return new Stream<Document>(name, clientSupplier);
    }

    @Nonnull
    public static Stream<Document> stream(@Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
        return MongoSourceBuilder.stream("MongoStreamSource", clientSupplier);
    }

    @Nonnull
    public static Stream<Document> stream(@Nonnull String name, @Nonnull DataConnectionRef dataConnectionRef) {
        return new Stream<Document>(name, dataConnectionRef);
    }

    @Nonnull
    public static Stream<Document> stream(@Nonnull DataConnectionRef dataConnectionRef) {
        return MongoSourceBuilder.stream("MongoStreamSource(" + dataConnectionRef.getName() + ")", dataConnectionRef);
    }

    public static final class Batch<T>
    extends Base<T, Batch<T>> {
        private Batch(@Nonnull String name, @Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
            Util.checkSerializable(clientSupplier, (String)"clientSupplier");
            this.name = name;
            this.params = new ReadMongoParams(false);
            this.params.setClientSupplier(clientSupplier).setMapItemFn(Mappers.toClass(Document.class));
        }

        private Batch(@Nonnull String name, @Nonnull DataConnectionRef dataConnectionRef) {
            Util.checkSerializable((Object)dataConnectionRef, (String)"clientSupplier");
            this.name = name;
            this.params = new ReadMongoParams(false);
            this.params.setDataConnectionRef(dataConnectionRef).setMapItemFn(Mappers.toClass(Document.class));
        }

        @Nonnull
        public <T_NEW> Batch<T_NEW> mapFn(@Nonnull FunctionEx<Document, T_NEW> mapFn) {
            Batch newThis = this;
            newThis.params.setMapItemFn(mapFn);
            return newThis;
        }

        @Nonnull
        public Batch<Document> collection(@Nullable String collectionName) {
            return this.collection(collectionName, Document.class);
        }

        @Nonnull
        public <T_NEW> Batch<T_NEW> collection(String collectionName, @Nonnull Class<T_NEW> mongoType) {
            Batch newThis = this;
            newThis.params.setCollectionName(collectionName);
            newThis.params.setMapItemFn(Mappers.toClass(mongoType));
            return newThis;
        }

        @Nonnull
        public BatchSource<T> build() {
            this.params.checkConnectivityOptionsValid();
            Preconditions.checkNotNull(this.params.getMapItemFn(), (String)"mapFn must be set");
            ReadMongoParams localParams = this.params;
            localParams.setCheckExistenceOnEachConnect(this.existenceChecks == ResourceChecks.ON_EACH_CONNECT);
            boolean checkResourceExistence = this.existenceChecks == ResourceChecks.ONCE_PER_JOB;
            return Sources.batchFromProcessor((String)this.name, (ProcessorMetaSupplier)new DbCheckingPMetaSupplierBuilder().withCheckResourceExistence(checkResourceExistence).withForceTotalParallelismOne(false).withDatabaseName(localParams.getDatabaseName()).withCollectionName(localParams.getCollectionName()).withClientSupplier(localParams.getClientSupplier()).withDataConnectionRef(localParams.getDataConnectionRef()).withProcessorSupplier(ProcessorSupplier.of((SupplierEx & Serializable)() -> new ReadMongoP(localParams))).build());
        }
    }

    public static final class Stream<T>
    extends Base<T, Stream<T>> {
        private Stream(@Nonnull String name, @Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
            Util.checkSerializable(clientSupplier, (String)"clientSupplier");
            this.name = name;
            this.params = new ReadMongoParams(true);
            this.params.setClientSupplier(clientSupplier);
            this.params.setMapStreamFn(Mappers.streamToClass(Document.class));
        }

        private Stream(@Nonnull String name, @Nonnull DataConnectionRef dataConnectionRef) {
            Util.checkSerializable((Object)dataConnectionRef, (String)"dataConnectionRef");
            this.name = name;
            this.params = new ReadMongoParams(true);
            this.params.setDataConnectionRef(dataConnectionRef);
            this.params.setMapStreamFn(Mappers.streamToClass(Document.class));
        }

        @Nonnull
        public Stream<Document> collection(@Nonnull String collectionName) {
            return this.collection(collectionName, Document.class);
        }

        @Nonnull
        public <T_NEW> Stream<T_NEW> collection(@Nonnull String collectionName, @Nonnull Class<T_NEW> mongoType) {
            Stream newThis = this;
            newThis.params.setCollectionName(collectionName);
            newThis.params.setMapStreamFn(Mappers.streamToClass(mongoType));
            return newThis;
        }

        @Nonnull
        public <T_NEW> Stream<T_NEW> mapFn(@Nonnull BiFunctionEx<ChangeStreamDocument<Document>, Long, T_NEW> mapFn) {
            Util.checkSerializable(mapFn, (String)"mapFn");
            Stream newThis = this;
            newThis.params.setMapStreamFn(mapFn);
            return newThis;
        }

        @Nonnull
        public Stream<T> startAtOperationTime(@Nonnull BsonTimestamp startAtOperationTime) {
            this.params.setStartAtTimestamp(startAtOperationTime);
            return this;
        }

        @Nonnull
        public StreamSource<T> build() {
            this.params.checkConnectivityOptionsValid();
            Preconditions.checkNotNull(this.params.getMapStreamFn(), (String)"mapFn must be set");
            ReadMongoParams localParams = this.params;
            boolean checkExistenceOnEachConnect = this.existenceChecks == ResourceChecks.ON_EACH_CONNECT;
            boolean checkExistenceOncePerJob = this.existenceChecks == ResourceChecks.ONCE_PER_JOB;
            boolean forceReadTotalParallelismOneLocal = this.forceReadTotalParallelismOne;
            localParams.setCheckExistenceOnEachConnect(checkExistenceOnEachConnect);
            return Sources.streamFromProcessorWithWatermarks((String)this.name, (boolean)true, (FunctionEx & Serializable)eventTimePolicy -> new DbCheckingPMetaSupplierBuilder().withCheckResourceExistence(checkExistenceOncePerJob).withForceTotalParallelismOne(forceReadTotalParallelismOneLocal).withDatabaseName(localParams.getDatabaseName()).withCollectionName(localParams.getCollectionName()).withClientSupplier(localParams.getClientSupplier()).withDataConnectionRef(localParams.getDataConnectionRef()).withProcessorSupplier(ProcessorSupplier.of((SupplierEx & Serializable)() -> new ReadMongoP(localParams.setEventTimePolicy(eventTimePolicy)))).build());
        }
    }

    private static abstract class Base<T, SELF extends Base<T, SELF>> {
        protected ReadMongoParams<T> params;
        protected ResourceChecks existenceChecks = ResourceChecks.ONCE_PER_JOB;
        protected String name;
        protected boolean forceReadTotalParallelismOne;

        private Base() {
        }

        @Nonnull
        public SELF database(String database) {
            this.params.setDatabaseName(database);
            return (SELF)this;
        }

        @Nonnull
        public SELF forceReadTotalParallelismOne(boolean forceReadTotalParallelismOne) {
            this.forceReadTotalParallelismOne = forceReadTotalParallelismOne;
            return (SELF)this;
        }

        @Nonnull
        public SELF checkResourceExistence(ResourceChecks checkResourceExistence) {
            this.existenceChecks = checkResourceExistence;
            return (SELF)this;
        }

        @Nonnull
        public SELF project(@Nonnull Bson projection) {
            this.params.setProjection(Mappers.bsonToDocument(Aggregates.project(projection)));
            return (SELF)this;
        }

        @Nonnull
        public SELF sort(@Nonnull Bson sort) {
            this.params.setSort(Mappers.bsonToDocument(Aggregates.sort(sort)));
            return (SELF)this;
        }

        @Nonnull
        public SELF filter(@Nonnull Bson filter) {
            Preconditions.checkNotNull((Object)filter, (String)"filter argument cannot be null");
            this.params.setFilter(Mappers.bsonToDocument(Aggregates.match(filter)));
            return (SELF)this;
        }
    }
}

