/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.mongodb.MongoSinkBuilder;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.Sink;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.bson.Document;

public final class MongoSinks {
    private MongoSinks() {
    }

    public static <T> MongoSinkBuilder<T> builder(@Nonnull Class<T> itemClass, @Nonnull SupplierEx<MongoClient> clientSupplier) {
        String name = "MongoSink(" + itemClass.getSimpleName() + ")";
        return new MongoSinkBuilder<T>(name, itemClass, clientSupplier);
    }

    public static <T> MongoSinkBuilder<T> builder(@Nonnull Class<T> itemClass, @Nonnull DataConnectionRef dataConnectionRef) {
        String name = "MongoSink(" + itemClass.getSimpleName() + ")";
        return new MongoSinkBuilder<T>(name, itemClass, dataConnectionRef);
    }

    public static Sink<Document> mongodb(@Nonnull String connectionString, @Nonnull String database, @Nonnull String collection) {
        String name = "MongoSink(" + database + "/" + collection + ")";
        return new MongoSinkBuilder<Document>(name, Document.class, (SupplierEx<MongoClient>)(SupplierEx & Serializable)() -> MongoClients.create(connectionString)).into(database, collection).identifyDocumentBy("_id", (FunctionEx<Document, Object>)(FunctionEx & Serializable)doc -> doc.get("_id")).build();
    }

    public static Sink<Document> mongodb(@Nonnull DataConnectionRef dataConnectionRef, @Nonnull String database, @Nonnull String collection) {
        String name = "MongoSink(ref " + String.valueOf(dataConnectionRef) + ")";
        return new MongoSinkBuilder<Document>(name, Document.class, dataConnectionRef).into(database, collection).identifyDocumentBy("_id", (FunctionEx<Document, Object>)(FunctionEx & Serializable)doc -> doc.get("_id")).build();
    }
}

