/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.mongodb.ResourceChecks;
import com.hazelcast.jet.mongodb.WriteMode;
import com.hazelcast.jet.mongodb.impl.DbCheckingPMetaSupplierBuilder;
import com.hazelcast.jet.mongodb.impl.WriteMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.retry.IntervalFunction;
import com.hazelcast.jet.retry.RetryStrategies;
import com.hazelcast.jet.retry.RetryStrategy;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.ReplaceOptions;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.bson.BsonDocument;
import org.bson.Document;

public final class MongoSinkBuilder<T> {
    public static final TransactionOptions DEFAULT_TRANSACTION_OPTION = TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).maxCommitTime(10L, TimeUnit.MINUTES).readPreference(ReadPreference.primaryPreferred()).build();
    public static final RetryStrategy DEFAULT_COMMIT_RETRY_STRATEGY = RetryStrategies.custom().intervalFunction(IntervalFunction.exponentialBackoffWithCap((long)100L, (double)2.0, (long)3000L)).maxAttempts(20).build();
    private final String name;
    private final WriteMongoParams<T> params = new WriteMongoParams();
    private int preferredLocalParallelism = 2;
    private ResourceChecks existenceChecks = ResourceChecks.ONCE_PER_JOB;

    MongoSinkBuilder(@Nonnull String name, @Nonnull Class<T> documentClass, @Nonnull SupplierEx<MongoClient> clientSupplier) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"sink name cannot be null");
        this.params.setClientSupplier((SupplierEx<MongoClient>)((SupplierEx)Util.checkNonNullAndSerializable(clientSupplier, (String)"clientSupplier")));
        this.params.setDocumentType((Class)Preconditions.checkNotNull(documentClass, (String)"document class cannot be null"));
        if (Document.class.isAssignableFrom(documentClass)) {
            this.identifyDocumentBy("_id", (FunctionEx & Serializable)doc -> ((Document)doc).get("_id"));
        }
        if (BsonDocument.class.isAssignableFrom(documentClass)) {
            this.identifyDocumentBy("_id", (FunctionEx & Serializable)doc -> ((BsonDocument)doc).get("_id"));
        }
        this.transactionOptions((SupplierEx<TransactionOptions>)(SupplierEx & Serializable)() -> DEFAULT_TRANSACTION_OPTION);
        this.commitRetryStrategy(DEFAULT_COMMIT_RETRY_STRATEGY);
    }

    MongoSinkBuilder(@Nonnull String name, @Nonnull Class<T> documentClass, @Nonnull DataConnectionRef dataConnectionRef) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"sink name cannot be null");
        this.params.setDataConnectionRef((DataConnectionRef)Util.checkNonNullAndSerializable((Object)dataConnectionRef, (String)"dataConnectionRef"));
        this.params.setDocumentType((Class)Preconditions.checkNotNull(documentClass, (String)"document class cannot be null"));
        if (Document.class.isAssignableFrom(documentClass)) {
            this.identifyDocumentBy("_id", (FunctionEx & Serializable)doc -> ((Document)doc).get("_id"));
        }
        if (BsonDocument.class.isAssignableFrom(documentClass)) {
            this.identifyDocumentBy("_id", (FunctionEx & Serializable)doc -> ((BsonDocument)doc).get("_id"));
        }
        this.transactionOptions((SupplierEx<TransactionOptions>)(SupplierEx & Serializable)() -> DEFAULT_TRANSACTION_OPTION);
        this.commitRetryStrategy(DEFAULT_COMMIT_RETRY_STRATEGY);
    }

    @Nonnull
    public MongoSinkBuilder<T> into(@Nonnull FunctionEx<T, String> selectDatabaseNameFn, @Nonnull FunctionEx<T, String> selectCollectionNameFn) {
        this.params.setDatabaseNameSelectFn(selectDatabaseNameFn);
        this.params.setCollectionNameSelectFn(selectCollectionNameFn);
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> into(@Nonnull String databaseName, @Nonnull String collectionName) {
        this.params.setDatabaseName(databaseName);
        this.params.setCollectionName(collectionName);
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> preferredLocalParallelism(int preferredLocalParallelism) {
        this.preferredLocalParallelism = Vertex.checkLocalParallelism((int)preferredLocalParallelism);
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> withCustomReplaceOptions(@Nonnull ConsumerEx<ReplaceOptions> adjustConsumer) {
        this.params.setReplaceOptionAdjuster((ConsumerEx<ReplaceOptions>)((ConsumerEx)Util.checkNonNullAndSerializable(adjustConsumer, (String)"adjustConsumer")));
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> identifyDocumentBy(@Nonnull String fieldName, @Nonnull FunctionEx<T, Object> documentIdentityFn) {
        Preconditions.checkNotNull((Object)fieldName, (String)"fieldName cannot be null");
        Util.checkSerializable(documentIdentityFn, (String)"documentIdentityFn");
        this.params.setDocumentIdentityFieldName(fieldName);
        this.params.setDocumentIdentityFn(documentIdentityFn);
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> commitRetryStrategy(@Nonnull RetryStrategy commitRetryStrategy) {
        this.params.setCommitRetryStrategy(commitRetryStrategy);
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> transactionOptions(@Nonnull SupplierEx<TransactionOptions> transactionOptionsSup) {
        this.params.setTransactionOptionsSup(transactionOptionsSup);
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> writeMode(@Nonnull WriteMode writeMode) {
        this.params.setWriteMode(writeMode);
        return this;
    }

    @Nonnull
    public MongoSinkBuilder<T> checkResourceExistence(ResourceChecks checkResourceExistence) {
        this.existenceChecks = checkResourceExistence;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        this.params.checkValid();
        WriteMongoParams localParams = this.params;
        localParams.setCheckExistenceOnEachConnect(this.existenceChecks == ResourceChecks.ON_EACH_CONNECT);
        return Sinks.fromProcessor((String)this.name, (ProcessorMetaSupplier)new DbCheckingPMetaSupplierBuilder().withCheckResourceExistence(localParams.isCheckExistenceOnEachConnect()).withForceTotalParallelismOne(false).withDatabaseName(localParams.getDatabaseName()).withCollectionName(localParams.getCollectionName()).withClientSupplier(localParams.getClientSupplier()).withDataConnectionRef(localParams.getDataConnectionRef()).withProcessorSupplier(ProcessorSupplier.of((SupplierEx & Serializable)() -> new WriteMongoP(localParams))).withPreferredLocalParallelism(this.preferredLocalParallelism).build());
    }
}

