/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.math.Vector3D;

public class CGAlgorithms3D {
    private CGAlgorithms3D() {
    }

    public static double distance(Coordinate p0, Coordinate p1) {
        if (Double.isNaN(p0.getZ()) || Double.isNaN(p1.getZ())) {
            return p0.distance(p1);
        }
        double dx = p0.x - p1.x;
        double dy = p0.y - p1.y;
        double dz = p0.getZ() - p1.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distancePointSegment(Coordinate p, Coordinate A2, Coordinate B) {
        if (A2.equals3D(B)) {
            return CGAlgorithms3D.distance(p, A2);
        }
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y) + (B.getZ() - A2.getZ()) * (B.getZ() - A2.getZ());
        if (Double.isNaN(len2)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        double r = ((p.x - A2.x) * (B.x - A2.x) + (p.y - A2.y) * (B.y - A2.y) + (p.getZ() - A2.getZ()) * (B.getZ() - A2.getZ())) / len2;
        if (r <= 0.0) {
            return CGAlgorithms3D.distance(p, A2);
        }
        if (r >= 1.0) {
            return CGAlgorithms3D.distance(p, B);
        }
        double qx = A2.x + r * (B.x - A2.x);
        double qy = A2.y + r * (B.y - A2.y);
        double qz = A2.getZ() + r * (B.getZ() - A2.getZ());
        double dx = p.x - qx;
        double dy = p.y - qy;
        double dz = p.getZ() - qz;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceSegmentSegment(Coordinate A2, Coordinate B, Coordinate C2, Coordinate D) {
        double t2;
        double s2;
        if (A2.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(A2, C2, D);
        }
        if (C2.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(C2, A2, B);
        }
        double a = Vector3D.dot(A2, B, A2, B);
        double b = Vector3D.dot(A2, B, C2, D);
        double c = Vector3D.dot(C2, D, C2, D);
        double d = Vector3D.dot(A2, B, C2, A2);
        double e = Vector3D.dot(C2, D, C2, A2);
        double denom = a * c - b * b;
        if (Double.isNaN(denom)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        if (denom <= 0.0) {
            s2 = 0.0;
            t2 = b > c ? d / b : e / c;
        } else {
            s2 = (b * e - c * d) / denom;
            t2 = (a * e - b * d) / denom;
        }
        if (s2 < 0.0) {
            return CGAlgorithms3D.distancePointSegment(A2, C2, D);
        }
        if (s2 > 1.0) {
            return CGAlgorithms3D.distancePointSegment(B, C2, D);
        }
        if (t2 < 0.0) {
            return CGAlgorithms3D.distancePointSegment(C2, A2, B);
        }
        if (t2 > 1.0) {
            return CGAlgorithms3D.distancePointSegment(D, A2, B);
        }
        double x1 = A2.x + s2 * (B.x - A2.x);
        double y1 = A2.y + s2 * (B.y - A2.y);
        double z1 = A2.getZ() + s2 * (B.getZ() - A2.getZ());
        double x2 = C2.x + t2 * (D.x - C2.x);
        double y2 = C2.y + t2 * (D.y - C2.y);
        double z2 = C2.getZ() + t2 * (D.getZ() - C2.getZ());
        return CGAlgorithms3D.distance(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }
}

