/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.advise;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.Lists;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.Casing;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.shaded.org.apache.calcite.runtime.CalciteException;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.advise.SqlSimpleParser;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParseException;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParser;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonikerImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonikerType;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorWithHints;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.apache.calcite.util.trace.CalciteTrace;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class SqlAdvisor {
    public static final Logger LOGGER = CalciteTrace.PARSER_LOGGER;
    private static final String HINT_TOKEN = "_suggest_";
    private static final String UPPER_HINT_TOKEN = "_suggest_".toUpperCase(Locale.ROOT);
    private final SqlValidatorWithHints validator;
    private final SqlParser.Config parserConfig;
    private @Nullable String prevWord;
    private @Nullable Casing prevPreferredCasing;
    private @Nullable Set<String> reservedWordsSet;
    private @Nullable List<String> reservedWordsList;

    @Deprecated
    public SqlAdvisor(SqlValidatorWithHints validator) {
        this(validator, SqlParser.Config.DEFAULT);
    }

    public SqlAdvisor(SqlValidatorWithHints validator, SqlParser.Config parserConfig) {
        this.validator = validator;
        this.parserConfig = parserConfig;
    }

    private char quoteStart() {
        return this.parserConfig.quoting().string.charAt(0);
    }

    private char quoteEnd() {
        char quote = this.quoteStart();
        return quote == '[' ? (char)']' : (char)quote;
    }

    public List<SqlMoniker> getCompletionHints(String sql, int cursor, String[] replaced) {
        int wordEnd;
        int wordStart;
        boolean quoted = false;
        for (wordStart = cursor; wordStart > 0 && Character.isJavaIdentifierPart(sql.charAt(wordStart - 1)); --wordStart) {
        }
        if (wordStart > 0 && sql.charAt(wordStart - 1) == this.quoteStart()) {
            quoted = true;
            --wordStart;
        }
        if (wordStart < 0) {
            return Collections.emptyList();
        }
        for (wordEnd = cursor; wordEnd < sql.length() && Character.isJavaIdentifierPart(sql.charAt(wordEnd)); ++wordEnd) {
        }
        if (quoted && wordEnd < sql.length() && sql.charAt(wordEnd) == this.quoteEnd()) {
            ++wordEnd;
        }
        String word = replaced[0] = sql.substring(wordStart, cursor);
        if (wordStart < wordEnd) {
            sql = sql.substring(0, wordStart) + sql.substring(wordEnd);
        }
        List<SqlMoniker> completionHints = this.getCompletionHints0(sql, wordStart);
        if (quoted) {
            word = word.substring(1);
        }
        if (word.isEmpty()) {
            return ImmutableList.copyOf(completionHints);
        }
        ImmutableList.Builder result = new ImmutableList.Builder();
        Casing preferredCasing = this.getPreferredCasing(word);
        boolean ignoreCase = preferredCasing != Casing.UNCHANGED;
        for (SqlMoniker hint : completionHints) {
            List<String> names = hint.getFullyQualifiedNames();
            String cname = Util.last(names);
            if (!cname.regionMatches(ignoreCase, 0, word, 0, word.length())) continue;
            result.add(hint);
        }
        return result.build();
    }

    public List<SqlMoniker> getCompletionHints0(String sql, int cursor) {
        String simpleSql = this.simplifySql(sql, cursor);
        int idx = simpleSql.indexOf(HINT_TOKEN);
        if (idx < 0) {
            return Collections.emptyList();
        }
        SqlParserPos pos = new SqlParserPos(1, idx + 1);
        return this.getCompletionHints(simpleSql, pos);
    }

    private Casing getPreferredCasing(String word) {
        int codePoint;
        if (word == this.prevWord) {
            return Nullness.castNonNull(this.prevPreferredCasing);
        }
        boolean hasLower = false;
        boolean hasUpper = false;
        for (int i = 0; !(i >= word.length() || hasLower && hasUpper); hasLower |= Character.isLowerCase(codePoint), hasUpper |= Character.isUpperCase(codePoint), i += Character.charCount(codePoint)) {
            codePoint = word.codePointAt(i);
        }
        Casing preferredCasing = hasUpper && !hasLower ? Casing.TO_UPPER : (!hasUpper && hasLower ? Casing.TO_LOWER : Casing.UNCHANGED);
        this.prevWord = word;
        this.prevPreferredCasing = preferredCasing;
        return preferredCasing;
    }

    public String getReplacement(SqlMoniker hint, String word) {
        Casing preferredCasing = this.getPreferredCasing(word);
        boolean quoted = !word.isEmpty() && word.charAt(0) == this.quoteStart();
        return this.getReplacement(hint, quoted, preferredCasing);
    }

    public String getReplacement(SqlMoniker hint, boolean quoted, Casing preferredCasing) {
        String name = Util.last(hint.getFullyQualifiedNames());
        boolean isKeyword = hint.getType() == SqlMonikerType.KEYWORD;
        if (!(quoted &= !isKeyword) && !isKeyword && this.getReservedAndKeyWordsSet().contains(name)) {
            quoted = true;
        }
        StringBuilder sb = new StringBuilder(name.length() + (quoted ? 2 : 0));
        if (!isKeyword && !Util.isValidJavaIdentifier(name)) {
            quoted = true;
        }
        String idToAppend = name;
        if (!quoted) {
            String preferredId = SqlAdvisor.applyCasing(name, preferredCasing);
            if (isKeyword || this.matchesUnquoted(name, preferredId)) {
                idToAppend = preferredId;
            } else {
                boolean bl = quoted = !this.matchesUnquoted(name, idToAppend);
            }
        }
        if (quoted) {
            sb.append(this.quoteStart());
        }
        sb.append(idToAppend);
        if (quoted) {
            sb.append(this.quoteEnd());
        }
        return sb.toString();
    }

    private boolean matchesUnquoted(String name, String idToAppend) {
        String recasedId = SqlAdvisor.applyCasing(idToAppend, this.parserConfig.unquotedCasing());
        return recasedId.regionMatches(!this.parserConfig.caseSensitive(), 0, name, 0, name.length());
    }

    private static String applyCasing(String value, Casing casing) {
        return SqlParserUtil.toCase(value, casing);
    }

    public List<SqlMoniker> getCompletionHints(String sql, SqlParserPos pos) {
        String hintToken;
        ArrayList<SqlMoniker> hintList = new ArrayList<SqlMoniker>();
        SqlNode sqlNode = this.tryParse(sql, hintList);
        if (sqlNode == null) {
            return hintList;
        }
        int x = pos.getColumnNum() - 1;
        sql = sql.substring(0, x) + " \u0007" + sql.substring(x);
        this.tryParse(sql, hintList);
        SqlMonikerImpl star = new SqlMonikerImpl(ImmutableList.of("*"), SqlMonikerType.KEYWORD);
        String string = hintToken = this.parserConfig.unquotedCasing() == Casing.TO_UPPER ? UPPER_HINT_TOKEN : HINT_TOKEN;
        if (hintList.contains(star) && !SqlAdvisor.isSelectListItem(sqlNode, pos, hintToken)) {
            hintList.remove(star);
        }
        try {
            this.validator.validate(sqlNode);
        }
        catch (Exception e) {
            Util.swallow(e, LOGGER);
        }
        List<SqlMoniker> validatorHints = this.validator.lookupHints(sqlNode, pos);
        hintList.addAll(validatorHints);
        return hintList;
    }

    private static boolean isSelectListItem(SqlNode root, SqlParserPos pos, String hintToken) {
        List<SqlNode> nodes = SqlUtil.getAncestry(root, input -> input instanceof SqlIdentifier && ((SqlIdentifier)input).names.contains(hintToken), input -> Objects.requireNonNull(input, "input").getParserPosition().startsAt(pos));
        assert (nodes.get(0) == root);
        return (nodes = Lists.reverse(nodes)).size() > 2 && nodes.get(2) instanceof SqlSelect && nodes.get(1) == ((SqlSelect)nodes.get(2)).getSelectList();
    }

    private @Nullable SqlNode tryParse(String sql, List<SqlMoniker> hintList) {
        try {
            return this.parseQuery(sql);
        }
        catch (SqlParseException e) {
            for (String tokenName : e.getExpectedTokenNames()) {
                if (!tokenName.startsWith("\"") || !tokenName.endsWith("\"")) continue;
                hintList.add(new SqlMonikerImpl(tokenName.substring(1, tokenName.length() - 1), SqlMonikerType.KEYWORD));
            }
            return null;
        }
        catch (CalciteException e) {
            Util.swallow(e, null);
            return null;
        }
    }

    public @Nullable SqlMoniker getQualifiedName(String sql, int cursor) {
        SqlNode sqlNode;
        try {
            sqlNode = this.parseQuery(sql);
            this.validator.validate(sqlNode);
        }
        catch (Exception e) {
            return null;
        }
        SqlParserPos pos = new SqlParserPos(1, cursor + 1);
        try {
            return this.validator.lookupQualifiedName(sqlNode, pos);
        }
        catch (CalciteContextException | AssertionError e) {
            return null;
        }
    }

    public boolean isValid(String sql) {
        SqlNode sqlNode;
        SqlSimpleParser simpleParser = new SqlSimpleParser(HINT_TOKEN, this.parserConfig);
        String simpleSql = simpleParser.simplifySql(sql);
        try {
            sqlNode = this.parseQuery(simpleSql);
        }
        catch (Exception e) {
            return false;
        }
        try {
            this.validator.validate(sqlNode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public @Nullable List<ValidateErrorInfo> validate(String sql) {
        ArrayList<ValidateErrorInfo> errorList = new ArrayList<ValidateErrorInfo>();
        SqlNode sqlNode = this.collectParserError(sql, errorList);
        if (!errorList.isEmpty()) {
            return errorList;
        }
        if (sqlNode == null) {
            throw new IllegalStateException("collectParserError returned null (sql is not valid), however, the resulting errorList is empty. sql=" + sql);
        }
        try {
            this.validator.validate(sqlNode);
        }
        catch (CalciteContextException e) {
            ValidateErrorInfo errInfo = new ValidateErrorInfo(e);
            errorList.add(errInfo);
            return errorList;
        }
        catch (Exception e) {
            ValidateErrorInfo errInfo = new ValidateErrorInfo(1, 1, 1, sql.length(), e.getMessage());
            errorList.add(errInfo);
            return errorList;
        }
        return null;
    }

    public String simplifySql(String sql, int cursor) {
        SqlSimpleParser parser = new SqlSimpleParser(HINT_TOKEN, this.parserConfig);
        return parser.simplifySql(sql, cursor);
    }

    @EnsuresNonNull(value={"reservedWordsSet", "reservedWordsList"})
    public List<String> getReservedAndKeyWords() {
        this.ensureReservedAndKeyWords();
        return this.reservedWordsList;
    }

    @EnsuresNonNull(value={"reservedWordsSet", "reservedWordsList"})
    private Set<String> getReservedAndKeyWordsSet() {
        this.ensureReservedAndKeyWords();
        return this.reservedWordsSet;
    }

    @EnsuresNonNull(value={"reservedWordsSet", "reservedWordsList"})
    private void ensureReservedAndKeyWords() {
        if (this.reservedWordsSet != null && this.reservedWordsList != null) {
            return;
        }
        Set<String> c = SqlAbstractParserImpl.getSql92ReservedWords();
        List<String> l = Arrays.asList(this.getParserMetadata().getJdbcKeywords().split(","));
        ArrayList<String> al = new ArrayList<String>();
        al.addAll(c);
        al.addAll(l);
        this.reservedWordsList = al;
        this.reservedWordsSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.reservedWordsSet.addAll(this.reservedWordsList);
    }

    protected SqlAbstractParserImpl.Metadata getParserMetadata() {
        SqlParser parser = SqlParser.create("", this.parserConfig);
        return parser.getMetadata();
    }

    protected SqlNode parseQuery(String sql) throws SqlParseException {
        SqlParser parser = SqlParser.create(sql, this.parserConfig);
        return parser.parseStmt();
    }

    protected @Nullable SqlNode collectParserError(String sql, List<ValidateErrorInfo> errorList) {
        try {
            return this.parseQuery(sql);
        }
        catch (SqlParseException e) {
            ValidateErrorInfo errInfo = new ValidateErrorInfo(e.getPos(), e.getMessage());
            errorList.add(errInfo);
            return null;
        }
    }

    public static class ValidateErrorInfo {
        private int startLineNum;
        private int startColumnNum;
        private int endLineNum;
        private int endColumnNum;
        private @Nullable String errorMsg;

        public ValidateErrorInfo(int startLineNum, int startColumnNum, int endLineNum, int endColumnNum, @Nullable String errorMsg) {
            this.startLineNum = startLineNum;
            this.startColumnNum = startColumnNum;
            this.endLineNum = endLineNum;
            this.endColumnNum = endColumnNum;
            this.errorMsg = errorMsg;
        }

        public ValidateErrorInfo(CalciteContextException e) {
            this.startLineNum = e.getPosLine();
            this.startColumnNum = e.getPosColumn();
            this.endLineNum = e.getEndPosLine();
            this.endColumnNum = e.getEndPosColumn();
            Throwable cause = e.getCause();
            this.errorMsg = (cause == null ? e : cause).getMessage();
        }

        public ValidateErrorInfo(SqlParserPos pos, @Nullable String errorMsg) {
            this.startLineNum = pos.getLineNum();
            this.startColumnNum = pos.getColumnNum();
            this.endLineNum = pos.getEndLineNum();
            this.endColumnNum = pos.getEndColumnNum();
            this.errorMsg = errorMsg;
        }

        public int getStartLineNum() {
            return this.startLineNum;
        }

        public int getStartColumnNum() {
            return this.startColumnNum;
        }

        public int getEndLineNum() {
            return this.endLineNum;
        }

        public int getEndColumnNum() {
            return this.endColumnNum;
        }

        public @Nullable String getMessage() {
            return this.errorMsg;
        }
    }
}

