/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.TimestampString;
import java.util.Objects;

public class SqlTimestampLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimestampLiteral(TimestampString ts, int precision, SqlTypeName typeName, SqlParserPos pos) {
        super(ts, false, typeName, precision, pos);
        Preconditions.checkArgument(this.precision >= 0);
        Preconditions.checkArgument(typeName == SqlTypeName.TIMESTAMP || typeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    }

    @Override
    public SqlTimestampLiteral clone(SqlParserPos pos) {
        return new SqlTimestampLiteral((TimestampString)Objects.requireNonNull(this.value, "value"), this.precision, this.getTypeName(), pos);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getTypeName()) + " '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        TimestampString ts = this.getTimestamp();
        if (this.precision > 0) {
            ts = ts.round(this.precision);
        }
        return ts.toString(this.precision);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseDateTimeLiteral(writer, this, leftPrec, rightPrec);
    }
}

