/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.plan;

import com.hazelcast.shaded.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.shaded.org.apache.calcite.materialize.Lattice;
import com.hazelcast.shaded.org.apache.calcite.materialize.MaterializationService;
import com.hazelcast.shaded.org.apache.calcite.materialize.TileKey;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptMaterialization;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class RelOptLattice {
    public final Lattice lattice;
    public final RelOptTable starRelOptTable;

    public RelOptLattice(Lattice lattice, RelOptTable starRelOptTable) {
        this.lattice = lattice;
        this.starRelOptTable = starRelOptTable;
    }

    public RelOptTable rootTable() {
        return this.lattice.rootNode.relOptTable();
    }

    public @Nullable RelNode rewrite(RelNode node) {
        return RelOptMaterialization.tryUseStar(node, this.starRelOptTable);
    }

    public @Nullable Pair<CalciteSchema.TableEntry, TileKey> getAggregate(RelOptPlanner planner, ImmutableBitSet groupSet, List<Lattice.Measure> measureList) {
        CalciteConnectionConfig config = planner.getContext().unwrap(CalciteConnectionConfig.class);
        if (config == null) {
            return null;
        }
        MaterializationService service = MaterializationService.instance();
        boolean create = this.lattice.auto && config.createMaterializations();
        CalciteSchema schema = this.starRelOptTable.unwrap(CalciteSchema.class);
        assert (schema != null) : "Can't get CalciteSchema from " + this.starRelOptTable;
        return service.defineTile(this.lattice, groupSet, measureList, schema, create, false);
    }
}

