/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hazelcast.shaded.org.apache.calcite.model.JsonLattice;
import com.hazelcast.shaded.org.apache.calcite.model.ModelHandler;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public class JsonMaterialization {
    public final @Nullable String view;
    public final @Nullable String table;
    public final Object sql;
    public final @Nullable List<String> viewSchemaPath;

    @JsonCreator
    public JsonMaterialization(@JsonProperty(value="view") @Nullable String view, @JsonProperty(value="table") @Nullable String table, @JsonProperty(value="sql", required=true) Object sql, @JsonProperty(value="viewSchemaPath") @Nullable List<String> viewSchemaPath) {
        this.view = view;
        this.table = table;
        this.sql = Objects.requireNonNull(sql, "sql");
        this.viewSchemaPath = viewSchemaPath;
    }

    public void accept(ModelHandler handler) {
        handler.visit(this);
    }

    public String toString() {
        return "JsonMaterialization(table=" + this.table + ", view=" + this.view + ")";
    }

    public String getSql() {
        return JsonLattice.toString(this.sql);
    }
}

