/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlDataType;
import com.hazelcast.jet.sql.impl.parse.SqlMappingColumn;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.UnparseUtil;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.sql.impl.schema.Mapping;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class SqlCreateMapping
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE EXTERNAL MAPPING", SqlKind.CREATE_TABLE);
    private final SqlIdentifier name;
    private final SqlIdentifier externalName;
    private final SqlNodeList columns;
    private final SqlIdentifier dataConnection;
    private final SqlIdentifier connectorType;
    private final SqlIdentifier objectType;
    private final SqlNodeList options;

    public SqlCreateMapping(SqlIdentifier name, SqlIdentifier externalName, SqlNodeList columns, SqlIdentifier dataConnection, SqlIdentifier connectorType, SqlIdentifier objectType, SqlNodeList options, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.externalName = externalName;
        this.columns = Objects.requireNonNull(columns, "Columns should not be null");
        this.dataConnection = dataConnection;
        this.connectorType = connectorType;
        this.objectType = objectType;
        this.options = Objects.requireNonNull(options, "Options should not be null");
        assert (dataConnection == null || connectorType == null);
    }

    public String nameWithoutSchema() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public String[] externalName() {
        String[] stringArray;
        if (this.externalName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.nameWithoutSchema();
        } else {
            stringArray = this.externalName.names.toArray(new String[0]);
        }
        return stringArray;
    }

    public Stream<SqlMappingColumn> columns() {
        return this.columns.getList().stream().map(node -> (SqlMappingColumn)node);
    }

    public String dataConnectionNameWithoutSchema() {
        if (this.dataConnection == null) {
            return null;
        }
        return (String)this.dataConnection.names.get(this.dataConnection.names.size() - 1);
    }

    public String connectorType() {
        return this.connectorType != null ? this.connectorType.toString() : null;
    }

    public String objectType() {
        return this.objectType != null ? this.objectType.toString() : null;
    }

    public Map<String, String> options() {
        return this.options.getList().stream().map(node -> (SqlOption)node).collect(LinkedHashMap::new, (map, option) -> map.putIfAbsent(option.keyString(), option.valueString()), Map::putAll);
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columns, this.dataConnection, this.connectorType, this.objectType, this.options);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("EXTERNAL MAPPING");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.externalName != null) {
            writer.keyword("EXTERNAL NAME");
            this.externalName.unparse(writer, leftPrec, rightPrec);
        }
        if (!this.columns.isEmpty()) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode column : this.columns) {
                UnparseUtil.printIndent(writer);
                column.unparse(writer, 0, 0);
            }
            writer.newlineAndIndent();
            writer.endList(frame);
        }
        if (this.dataConnection != null) {
            writer.newlineAndIndent();
            writer.keyword("DATA CONNECTION");
            this.dataConnection.unparse(writer, leftPrec, rightPrec);
        } else {
            assert (this.connectorType != null);
            writer.newlineAndIndent();
            writer.keyword("TYPE");
            this.connectorType.unparse(writer, leftPrec, rightPrec);
        }
        if (this.objectType != null) {
            writer.newlineAndIndent();
            writer.keyword("OBJECT TYPE");
            this.objectType.unparse(writer, leftPrec, rightPrec);
        }
        UnparseUtil.unparseOptions(writer, this.options);
    }

    public static String unparse(Mapping mapping) {
        SqlPrettyWriter writer = new SqlPrettyWriter(SqlPrettyWriter.config());
        SqlCreateMapping m4 = new SqlCreateMapping(UnparseUtil.identifier("hazelcast", "public", mapping.name()), UnparseUtil.identifier(mapping.externalName()), UnparseUtil.nodeList(mapping.fields(), f -> new SqlMappingColumn(UnparseUtil.identifier(f.name()), new SqlDataType(f.type(), SqlParserPos.ZERO), UnparseUtil.identifier(f.externalName()), SqlParserPos.ZERO)), UnparseUtil.identifier(mapping.dataConnection()), UnparseUtil.identifier(mapping.connectorType()), UnparseUtil.identifier(mapping.objectType()), UnparseUtil.reconstructOptions(mapping.options()), true, false, SqlParserPos.ZERO);
        m4.unparse(writer, 0, 0);
        return writer.toString();
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace() && this.ifNotExists) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.orReplaceWithIfNotExistsNotSupported());
        }
        if (!ValidationUtil.isCatalogObjectNameValid(this.name)) {
            throw validator.newValidationError(this.name, ParserResource.RESOURCE.mappingIncorrectSchema());
        }
        if (this.dataConnection != null && !ValidationUtil.isCatalogObjectNameValid(this.dataConnection)) {
            throw validator.newValidationError(this.name, ParserResource.RESOURCE.dataConnectionIncorrectSchemaUse());
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (SqlNode column : this.columns.getList()) {
            String name = ((SqlMappingColumn)column).name();
            if (columnNames.add(name)) continue;
            throw validator.newValidationError(column, ParserResource.RESOURCE.duplicateColumn(name));
        }
        HashSet<String> optionNames = new HashSet<String>();
        for (SqlNode option : this.options.getList()) {
            String name = ((SqlOption)option).keyString();
            if (optionNames.add(name)) continue;
            throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(name));
        }
    }
}

