/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.WatermarkPolicy;
import com.hazelcast.jet.core.function.ObjLongBiFunction;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.HazelcastPhysicalScan;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.opt.FullScan;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.cost.CostUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class FullScanPhysicalRel
extends FullScan
implements HazelcastPhysicalScan {
    private final int discriminator;

    FullScanPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, @Nullable Expression<?> lagExpression, int watermarkedColumnIndex, int discriminator) {
        super(cluster, traitSet, table, lagExpression, watermarkedColumnIndex);
        this.discriminator = discriminator;
    }

    @Override
    public RexNode filter() {
        return this.getTable().unwrap(HazelcastTable.class).getFilter();
    }

    @Override
    public List<RexNode> projection() {
        return this.getTable().unwrap(HazelcastTable.class).getProjects();
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        List fieldTypes = Util.toList(this.projection(), rexNode -> HazelcastTypeUtils.toHazelcastType(rexNode.getType()));
        return new PlanNodeSchema(fieldTypes);
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        return visitor.onFullScan(this);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double totalRowCount;
        HazelcastTable table = this.getTable().unwrap(HazelcastTable.class);
        double filterRowCount = totalRowCount = table.getStatistic().getRowCount() != null ? table.getTotalRowCount() : this.getTable().getRowCount();
        if (table.getFilter() != null) {
            filterRowCount = CostUtils.adjustFilteredRowCount(totalRowCount, RelMdUtil.guessSelectivity(table.getFilter()));
        }
        return FullScanPhysicalRel.computeSelfCost(planner, totalRowCount, table.getFilter() != null, filterRowCount, table.getProjects().size());
    }

    private static RelOptCost computeSelfCost(RelOptPlanner planner, double scanRowCount, boolean hasFilter, double filterRowCount, int projectCount) {
        double scanCpu = scanRowCount * 1.0;
        double filterCpu = hasFilter ? CostUtils.adjustCpuForConstrainedScan(scanCpu) : 0.0;
        double projectCpu = CostUtils.adjustCpuForConstrainedScan(CostUtils.getProjectCpu(filterRowCount, projectCount));
        return planner.getCostFactory().makeCost(filterRowCount, scanCpu + filterCpu + projectCpu, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        HazelcastTable hazelcastTable = OptUtils.extractHazelcastTable(this);
        Map<String, List<Map<String, RexNode>>> candidates = OptUtils.metadataQuery(this).extractPrunability(this);
        boolean isPrunable = !candidates.isEmpty();
        String partitioningKey = "";
        String partitioningKeyValues = "";
        if (hazelcastTable.getTarget() instanceof PartitionedMapTable && isPrunable) {
            PartitionedMapTable target = (PartitionedMapTable)hazelcastTable.getTarget();
            List fieldIndexes = target.partitioningAttributes().isEmpty() ? target.keyFields().map(f -> target.getFieldIndex(f.getName())).collect(Collectors.toList()) : target.keyFields().filter(kf -> target.partitioningAttributes().contains(kf.getPath().getPath())).map(TableField::getName).map(target::getFieldIndex).collect(Collectors.toList());
            partitioningKey = fieldIndexes.stream().map(index -> "$" + index).collect(Collectors.joining(", "));
            List fieldNames = fieldIndexes.stream().map(fieldIndex -> target.getField((int)fieldIndex)).map(TableField::getName).collect(Collectors.toList());
            partitioningKeyValues = candidates.get(target.getSqlName()).stream().map(candidate -> fieldNames.stream().map(candidate::get).filter(Objects::nonNull).map(RexNode::toString).collect(Collectors.joining(", "))).map(s2 -> "(" + s2 + ")").collect(Collectors.joining(", "));
        }
        return super.explainTerms(pw).item("discriminator", this.discriminator).itemIf("partitioningKey", partitioningKey, isPrunable).itemIf("partitioningKeyValues", partitioningKeyValues, isPrunable);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new FullScanPhysicalRel(this.getCluster(), traitSet, this.getTable(), this.lagExpression(), this.watermarkedColumnIndex(), this.discriminator());
    }

    public RelNode copy(RelTraitSet traitSet, int discriminator) {
        return new FullScanPhysicalRel(this.getCluster(), traitSet, this.getTable(), this.lagExpression(), this.watermarkedColumnIndex(), discriminator);
    }

    public int discriminator() {
        return this.discriminator;
    }

    public List<RexNode> getProjects() {
        HazelcastTable table = this.getTable().unwrap(HazelcastTable.class);
        return table.getProjects();
    }

    public BiFunctionEx<ExpressionEvalContext, Byte, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider(int wmColumnIndex, @Nullable Expression<?> lagExpression, long throttlingFrameSize) {
        if (lagExpression == null) {
            return null;
        }
        return (BiFunctionEx & Serializable)(context, watermarkKey) -> {
            long lagMs = WindowUtils.extractMillis(lagExpression, context);
            return EventTimePolicy.eventTimePolicy((ToLongFunctionEx & Serializable)row -> WindowUtils.extractMillis(row.get(wmColumnIndex)), (ObjLongBiFunction & Serializable)(row, timestamp) -> row, (SupplierEx)WatermarkPolicy.limitingLag((long)lagMs), (long)throttlingFrameSize, (long)0L, (long)60000L, (byte)watermarkKey);
        };
    }
}

