/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.logical.ImmutableScanCyclicTypeMustNotExecuteRule;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectType;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import java.util.HashSet;
import org.immutables.value.Value;

@Value.Enclosing
public final class ScanCyclicTypeMustNotExecuteRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final RelOptRule INSTANCE = new ScanCyclicTypeMustNotExecuteRule(Config.DEFAULT);

    private ScanCyclicTypeMustNotExecuteRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        TableScan rel = (TableScan)call.rel(0);
        for (RelDataTypeField field : rel.getRowType().getFieldList()) {
            RelDataType fieldType = field.getType();
            if (!(fieldType instanceof HazelcastObjectType) || !QueryUtils.containsCycles((HazelcastObjectType)fieldType, new HashSet<String>())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        throw QueryException.error((String)("Experimental feature of using cyclic custom types isn't enabled. To enable, set " + String.valueOf(ClusterProperty.SQL_CUSTOM_CYCLIC_TYPES_ENABLED) + " to true"));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableScanCyclicTypeMustNotExecuteRule.Config.builder().description(ScanCyclicTypeMustNotExecuteRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(TableScan.class).anyInputs()).build();

        @Override
        default public RelOptRule toRule() {
            return new ScanCyclicTypeMustNotExecuteRule(this);
        }
    }
}

