/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaWriter;
import com.hazelcast.internal.util.collection.DefaultedMap;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.CompactUpsertTargetDescriptor;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class MetadataCompactResolver
implements KvMetadataResolver {
    static final MetadataCompactResolver INSTANCE = new MetadataCompactResolver();
    private static final DefaultedMap<QueryDataTypeFamily, FieldKind> SQL_TO_COMPACT = new DefaultedMap.DefaultedMapBuilder(new EnumMap<QueryDataTypeFamily, FieldKind>(ImmutableMap.builder().put(QueryDataTypeFamily.BOOLEAN, FieldKind.NULLABLE_BOOLEAN).put(QueryDataTypeFamily.TINYINT, FieldKind.NULLABLE_INT8).put(QueryDataTypeFamily.SMALLINT, FieldKind.NULLABLE_INT16).put(QueryDataTypeFamily.INTEGER, FieldKind.NULLABLE_INT32).put(QueryDataTypeFamily.BIGINT, FieldKind.NULLABLE_INT64).put(QueryDataTypeFamily.REAL, FieldKind.NULLABLE_FLOAT32).put(QueryDataTypeFamily.DOUBLE, FieldKind.NULLABLE_FLOAT64).put(QueryDataTypeFamily.DECIMAL, FieldKind.DECIMAL).put(QueryDataTypeFamily.VARCHAR, FieldKind.STRING).put(QueryDataTypeFamily.TIME, FieldKind.TIME).put(QueryDataTypeFamily.DATE, FieldKind.DATE).put(QueryDataTypeFamily.TIMESTAMP, FieldKind.TIMESTAMP).put(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, FieldKind.TIMESTAMP_WITH_TIMEZONE).put(QueryDataTypeFamily.OBJECT, FieldKind.COMPACT).build())).orElseThrow(type -> new IllegalArgumentException("Compact format does not allow " + String.valueOf(type) + " data type"));

    private MetadataCompactResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("compact");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        if (userFields.isEmpty()) {
            throw QueryException.error((String)"Column list is required for Compact format");
        }
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        MetadataCompactResolver.getCompactTypeName(fieldsByPath, options, isKey);
        return fieldsByPath.entrySet().stream().map(entry -> {
            QueryPath path = (QueryPath)entry.getKey();
            if (path.isTopLevel()) {
                throw QueryException.error((String)("Cannot use the '" + String.valueOf(path) + "' field with Compact serialization"));
            }
            QueryDataType type = ((MappingField)entry.getValue()).type();
            if (type == QueryDataType.OBJECT) {
                throw QueryException.error((String)("Cannot derive Compact type for '" + String.valueOf((Object)type.getTypeFamily()) + "'"));
            }
            return (MappingField)entry.getValue();
        });
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        String typeName = MetadataCompactResolver.getCompactTypeName(fieldsByPath, options, isKey);
        ArrayList<TableField> fields = new ArrayList<TableField>(fieldsByPath.size());
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add(new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        Schema schema = MetadataCompactResolver.resolveSchema(typeName, KvMetadataResolver.getFields(fieldsByPath));
        return new KvMetadata(fields, GenericQueryTargetDescriptor.DEFAULT, new CompactUpsertTargetDescriptor(schema));
    }

    private static Schema resolveSchema(String typeName, Stream<KvMetadataResolver.Field> fields) {
        return ((SchemaWriter)Util.collect((Object)new SchemaWriter(typeName), fields, (schema, field) -> schema.addField(new FieldDescriptor(field.name(), (FieldKind)SQL_TO_COMPACT.getOrDefault((Object)field.type().getTypeFamily()))))).build();
    }

    private static String getCompactTypeName(Map<QueryPath, MappingField> fields, Map<String, String> options, boolean isKey) {
        return KvMetadataResolver.getMetadata(fields).orElseGet(() -> MetadataCompactResolver.compactTypeName(options, isKey));
    }

    public static String compactTypeName(Map<String, String> options, boolean isKey) {
        String typeNameProperty = isKey ? "keyCompactTypeName" : "valueCompactTypeName";
        String typeName = options.get(typeNameProperty);
        if (typeName == null) {
            throw QueryException.error((String)(typeNameProperty + " is required to create Compact-based mapping"));
        }
        return typeName;
    }
}

