/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.dataconnection.impl.JdbcDataConnection;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.DataSourceFromConnectionSupplier;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;

abstract class AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier {
    protected String dataConnectionName;
    protected transient JdbcDataConnection dataConnection;
    protected transient DataSource dataSource;

    AbstractJdbcSqlConnectorProcessorSupplier() {
    }

    AbstractJdbcSqlConnectorProcessorSupplier(String dataConnectionName) {
        this.dataConnectionName = Objects.requireNonNull(dataConnectionName, "dataConnectionName must not be null");
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        this.dataConnection = (JdbcDataConnection)context.dataConnectionService().getAndRetainDataConnection(this.dataConnectionName, JdbcDataConnection.class);
        this.dataSource = new DataSourceFromConnectionSupplier(() -> ((JdbcDataConnection)this.dataConnection).getConnection());
    }

    public void close(@Nullable Throwable error) throws Exception {
        if (this.dataConnection != null) {
            this.dataConnection.release();
        }
    }
}

