/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.RowsQueryEventData;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchema;
import io.debezium.connector.binlog.BinlogStreamingChangeEventSource;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.relational.TableId;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.util.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Predicate;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlStreamingChangeEventSource
extends BinlogStreamingChangeEventSource<MySqlPartition, MySqlOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlStreamingChangeEventSource.class);
    private final MySqlConnectorConfig connectorConfig;
    private GtidSet gtidSet;

    public MySqlStreamingChangeEventSource(MySqlConnectorConfig connectorConfig, BinlogConnectorConnection connection, EventDispatcher<MySqlPartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, MySqlTaskContext taskContext, MySqlStreamingChangeEventSourceMetrics metrics, SnapshotterService snapshotterService) {
        super(connectorConfig, connection, dispatcher, errorHandler, clock, taskContext, (BinlogDatabaseSchema)((Object)taskContext.getSchema()), metrics, snapshotterService);
        this.connectorConfig = connectorConfig;
    }

    @Override
    protected void setEventTimestamp(Event event, long eventTs) {
        if (this.eventTimestamp == null || !this.isGtidModeEnabled()) {
            this.eventTimestamp = Instant.ofEpochMilli(eventTs);
        } else if (event.getHeader().getEventType() == EventType.GTID) {
            GtidEventData gtidEvent = (GtidEventData)this.unwrapData(event);
            long gtidEventTs = gtidEvent.getOriginalCommitTimestamp();
            this.eventTimestamp = gtidEventTs != 0L ? Instant.EPOCH.plus(gtidEventTs, ChronoUnit.MICROS) : Instant.ofEpochMilli(eventTs);
        }
    }

    @Override
    protected void handleGtidEvent(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event, Predicate<String> gtidSourceFilter) {
        String uuid;
        LOGGER.debug("GTID transaction: {}", (Object)event);
        GtidEventData gtidEvent = (GtidEventData)this.unwrapData(event);
        String gtid = gtidEvent.getGtid();
        this.gtidSet.add(gtid);
        offsetContext.startGtid(gtid, this.gtidSet.toString());
        this.setIgnoreDmlEventByGtidSource(false);
        if (gtidSourceFilter != null && gtid != null && !gtidSourceFilter.test(uuid = gtid.trim().substring(0, gtid.indexOf(":")))) {
            this.setIgnoreDmlEventByGtidSource(true);
        }
        this.setGtidChanged(gtid);
    }

    @Override
    protected void handleRecordingQuery(MySqlOffsetContext offsetContext, Event event) {
        Object eventData = this.unwrapData(event);
        if (eventData instanceof RowsQueryEventData) {
            String query = ((RowsQueryEventData)eventData).getQuery();
            offsetContext.setQuery(query);
        }
    }

    public void init(MySqlOffsetContext offsetContext) {
        this.setEffectiveOffsetContext(offsetContext != null ? offsetContext : MySqlOffsetContext.initial(this.connectorConfig));
    }

    @Override
    protected Class<? extends SourceConnector> getConnectorClass() {
        return MySqlConnector.class;
    }

    @Override
    protected EventType getIncludeQueryEventType() {
        return EventType.ROWS_QUERY;
    }

    @Override
    protected EventType getGtidEventType() {
        return EventType.GTID;
    }

    @Override
    protected void initializeGtidSet(String value) {
        this.gtidSet = new GtidSet(value);
    }

    @Override
    protected SSLMode sslModeFor(BinlogConnectorConfig.SecureConnectionMode mode) {
        switch ((MySqlConnectorConfig.MySqlSecureConnectionMode)mode) {
            case DISABLED: {
                return SSLMode.DISABLED;
            }
            case PREFERRED: {
                return SSLMode.PREFERRED;
            }
            case REQUIRED: {
                return SSLMode.REQUIRED;
            }
            case VERIFY_CA: {
                return SSLMode.VERIFY_CA;
            }
            case VERIFY_IDENTITY: {
                return SSLMode.VERIFY_IDENTITY;
            }
        }
        return null;
    }
}

